"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.noThemeSnapshot = noThemeSnapshot;
exports.snapshotWithoutProps = snapshotWithoutProps;
var _enzymeToJson = _interopRequireDefault(require("enzyme-to-json"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function snapshotWithoutProps(enzymeWrapper, propNames) {
  let propNameList = propNames;
  if (!Array.isArray(propNames)) {
    propNameList = [propNames];
  }
  const snapshotOptions = {
    map: json => {
      propNameList.forEach(prop => {
        if (json.props[prop]) {
          json.props[prop] = `[ ${prop} object ]`;
        }
      });
      return json;
    }
  };
  return (0, _enzymeToJson.default)(enzymeWrapper, snapshotOptions);
}
function noThemeSnapshot(enzymeWrapper) {
  return snapshotWithoutProps(enzymeWrapper, "theme");
}