"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../../components/icon/icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const validationIconTypes = {
  error: "var(--colorsSemanticNegative500)",
  info: "var(--colorsSemanticInfo500)",
  warning: "var(--colorsSemanticCaution500)"
};
const oldFocusStyling = `
  outline: solid 2px var(--colorsSemanticFocus500);
`;
const ValidationIconStyle = _styledComponents.default.span`
  background: none;
  cursor: default;
  display: flex;
  align-items: center;
  margin-top: 0;
  margin-bottom: 0;
  border: 0;
  outline: none;

  ${({
  isPartOfInput
}) => isPartOfInput && (0, _styledComponents.css)`
      cursor: pointer;
    `}

  ${_icon.default}:before {
    color: ${({
  validationType
}) => validationIconTypes[validationType]};
  }

  ${_icon.default}:focus {
    ${({
  theme
}) => !theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
  }

  ${_styledSystem.margin}
`;
ValidationIconStyle.defaultProps = {
  validationType: "error",
  theme: _base.default
};
var _default = exports.default = ValidationIconStyle;