"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ValidationIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _guid = _interopRequireDefault(require("../utils/helpers/guid"));
var _icon = _interopRequireDefault(require("../../components/icon"));
var _validationIcon = _interopRequireDefault(require("./validation-icon.style"));
var _inputBehaviour = require("../input-behaviour");
var _utils = require("../../style/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const getValidationType = ({
  error,
  warning,
  info
}) => {
  if (error) return "error";
  if (warning) return "warning";
  if (info) return "info";
  return null;
};
const ValidationIcon = ({
  error,
  warning,
  info,
  size,
  onFocus,
  onBlur,
  iconId,
  tooltipId,
  isPartOfInput,
  tabIndex = -1,
  onClick,
  tooltipPosition = "right",
  tooltipFlipOverrides,
  ...rest
}) => {
  const validationTooltipId = (0, _react.useRef)(tooltipId || (0, _guid.default)());
  const flipBehaviourCheck = Array.isArray(tooltipFlipOverrides) && tooltipFlipOverrides.every(override => ["bottom", "left", "right", "top"].includes(override));
  if (tooltipFlipOverrides) {
    !flipBehaviourCheck ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `The tooltipFlipOverrides prop supplied to ValidationIcon must be an array containing some or all of ["top", "bottom", "left", "right"].`) : (0, _invariant.default)(false) : void 0;
  }
  const {
    hasFocus,
    hasMouseOver
  } = (0, _react.useContext)(_inputBehaviour.InputContext);
  const {
    hasFocus: groupHasFocus,
    hasMouseOver: groupHasMouseOver
  } = (0, _react.useContext)(_inputBehaviour.InputGroupContext);
  const [triggeredByIcon, setTriggeredByIcon] = (0, _react.useState)(false);
  const validationType = getValidationType({
    error,
    warning,
    info
  });
  const validationMessage = error || warning || info;
  if (typeof validationMessage !== "string" || !validationType) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_validationIcon.default, _extends({
    validationType: validationType,
    onClick: onClick,
    onMouseOver: () => setTriggeredByIcon(true),
    onMouseLeave: () => setTriggeredByIcon(false),
    onFocus: e => {
      setTriggeredByIcon(true);
      if (onFocus) onFocus(e);
    },
    onBlur: e => {
      setTriggeredByIcon(false);
      if (onBlur) onBlur(e);
    },
    isPartOfInput: isPartOfInput
  }, (0, _utils.filterStyledSystemMarginProps)(rest)), /*#__PURE__*/_react.default.createElement(_icon.default, {
    "aria-describedby": validationTooltipId.current,
    key: `${validationType}-icon`,
    type: validationType,
    tabIndex: tabIndex,
    tooltipId: validationTooltipId.current,
    tooltipMessage: validationMessage,
    tooltipPosition: tooltipPosition,
    tooltipVisible: hasFocus || hasMouseOver || groupHasFocus || groupHasMouseOver || triggeredByIcon,
    tooltipFlipOverrides: isPartOfInput && !tooltipFlipOverrides ? ["top", "bottom"] : tooltipFlipOverrides,
    isPartOfInput: isPartOfInput,
    inputSize: size,
    id: iconId,
    focusable: tabIndex !== -1
  }));
};
exports.ValidationIcon = ValidationIcon;
var _default = exports.default = ValidationIcon;