"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootTagTestRtl = exports.rootTagTest = exports.elementsTagTest = void 0;
const elementsTagTest = (wrapper, elements) => {
  elements.forEach(element => {
    it(`include 'data-element="${element}"'`, () => {
      expect(wrapper.find({
        "data-element": element
      }).length).toEqual(1);
    });
  });
};
exports.elementsTagTest = elementsTagTest;
const rootTagTest = (rootNode, comp, elem, role) => {
  expect(rootNode.prop("data-component")).toEqual(comp);
  expect(rootNode.prop("data-element")).toEqual(elem);
  expect(rootNode.prop("data-role")).toEqual(role);
};
exports.rootTagTest = rootTagTest;
const rootTagTestRtl = (rootNode, comp, elem, role) => {
  expect(rootNode).toHaveAttribute("data-component", comp);
  expect(rootNode).toHaveAttribute("data-element", elem);
  expect(rootNode).toHaveAttribute("data-role", role);
};

// eslint-disable-next-line jest/no-export
exports.rootTagTestRtl = rootTagTestRtl;