"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _throttle = _interopRequireDefault(require("lodash/throttle"));
var _stickyFooter = _interopRequireDefault(require("./sticky-footer.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const SCROLL_THROTTLE = 50;
const StickyFooter = ({
  children,
  containerRef,
  disableSticky,
  ...rest
}) => {
  const [isSticky, setIsSticky] = (0, _react.useState)(true);
  const footerRef = (0, _react.useRef)(null);
  const checkFooterPosition = (0, _react.useCallback)((0, _throttle.default)(() => {
    const content = containerRef.current;
    /* Fallback to 0 to satisfy the TypeScript compiler */
    /* footerRef will never be null in this method */
    /* istanbul ignore next */
    const stickyOffset = footerRef.current ? footerRef.current.clientHeight / 2 : 0;
    let fullyScrolled;

    // istanbul ignore else
    if (content) {
      fullyScrolled = content.scrollHeight - content.scrollTop - stickyOffset <= content.clientHeight;
    }
    setIsSticky(!fullyScrolled);
  }, SCROLL_THROTTLE), [containerRef]);
  (0, _react.useEffect)(() => {
    const content = containerRef.current;
    content?.addEventListener("scroll", checkFooterPosition, false);
    return () => {
      content?.removeEventListener("scroll", checkFooterPosition, false);
    };
  }, [checkFooterPosition, containerRef]);
  return /*#__PURE__*/_react.default.createElement(_stickyFooter.default, _extends({
    "data-component": "sticky-footer",
    sticky: disableSticky ? false : isSticky,
    ref: footerRef
  }, rest), children);
};
var _default = exports.default = StickyFooter;