"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RadioButtonMapper = ({
  children,
  name,
  onBlur,
  onChange,
  onMouseDown,
  onKeyDown,
  value
}) => {
  const filteredChildren = (0, _react.useMemo)(() => _react.default.Children.toArray(children), [children]);
  const anyChecked = (0, _react.useMemo)(() => {
    let result = false;
    filteredChildren.forEach(child => {
      if ( /*#__PURE__*/_react.default.isValidElement(child) && Object.prototype.hasOwnProperty.call(child.props, "defaultChecked")) {
        result = true;
      }
    });
    return result;
  }, [filteredChildren]);
  const isControlled = value !== undefined;
  const [checkedValue, setCheckedValue] = (0, _react.useState)(false);
  const onChangeProp = (0, _react.useCallback)(event => {
    onChange?.(event);
    /* istanbul ignore else */
    if (!isControlled) {
      setCheckedValue(event.target.value);
    }
  }, [onChange, setCheckedValue, isControlled]);
  const buttons = filteredChildren.map(child => {
    let checked;
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    if (isControlled) {
      // The user is controlling the input via the value prop
      checked = value === child.props.value;
    } else if (!checkedValue && anyChecked) {
      // Uncontrolled and the user has not made a selection, but at least one has a checked prop
      checked = child.props.defaultChecked || false;
    } else {
      // Uncontrolled, existing selection or none marked as checked
      checked = checkedValue === child.props.value;
    }
    const childProps = {
      defaultChecked: undefined,
      checked,
      name,
      onBlur,
      onMouseDown,
      onChange: onChangeProp,
      onKeyDown
    };
    return /*#__PURE__*/_react.default.cloneElement(child, childProps);
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, buttons);
};
RadioButtonMapper.displayName = "RadioButtonMapper";
var _default = exports.default = RadioButtonMapper;