"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _dom = require("@floating-ui/dom");
var _useFloating = _interopRequireDefault(require("../../hooks/__internal__/useFloating"));
var _popover = require("./popover.style");
var _carbonScopedTokensProvider = _interopRequireDefault(require("../../style/design-tokens/carbon-scoped-tokens-provider/carbon-scoped-tokens-provider.component"));
var _modal = require("../../components/modal/modal.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultMiddleware = [(0, _dom.flip)({
  fallbackStrategy: "initialPlacement"
})];
const Popover = ({
  children,
  placement,
  disablePortal,
  reference,
  middleware = defaultMiddleware,
  disableBackgroundUI,
  isOpen = true,
  animationFrame,
  popoverStrategy = "absolute",
  childRefOverride
}) => {
  const elementDOM = (0, _react.useRef)(null);
  const {
    isInModal
  } = (0, _react.useContext)(_modal.ModalContext);
  const candidateNode = reference.current?.closest("[role='dialog']");
  const mountNode = isInModal && candidateNode ? candidateNode : document.body;
  if (!elementDOM.current && !disablePortal) {
    elementDOM.current = document.createElement("div");
    mountNode.appendChild(elementDOM.current);
  }
  const childRef = childRefOverride || _react.default.Children.only(children).ref;
  const innerRef = (0, _react.useRef)(null);
  const floatingReference = childRef || innerRef;
  let content;
  if (childRef) {
    content = children;
  } else {
    content = /*#__PURE__*/_react.default.cloneElement(children, {
      ref: floatingReference
    });
  }
  (0, _useFloating.default)({
    isOpen,
    reference,
    floating: floatingReference,
    placement,
    middleware,
    animationFrame,
    strategy: popoverStrategy
  });
  (0, _react.useEffect)(() => {
    return () => {
      if (!disablePortal && elementDOM.current) {
        mountNode.removeChild(elementDOM.current);
        elementDOM.current = null;
      }
    };
  }, [disablePortal, mountNode]);
  if (!disableBackgroundUI) {
    content = /*#__PURE__*/_react.default.createElement(_popover.StyledPopoverContent, {
      isOpen: isOpen
    }, content);
  }
  if (disableBackgroundUI) {
    content = /*#__PURE__*/_react.default.createElement(_popover.StyledPopoverContent, {
      isOpen: isOpen
    }, /*#__PURE__*/_react.default.createElement(_popover.StyledBackdrop, null, content));
  }
  if (disablePortal) {
    return content;
  }
  return /*#__PURE__*/_reactDom.default.createPortal( /*#__PURE__*/_react.default.createElement(_carbonScopedTokensProvider.default, null, content), elementDOM.current);
};
var _default = exports.default = Popover;