"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledLabelContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledLabel = _styledComponents.default.label`
  color: var(--colorsUtilityYin090);
  display: block;
  font-weight: var(--fontWeights700);

  ${({
  isRequired
}) => isRequired && (0, _styledComponents.css)`
      ::after {
        content: "*";
        color: var(--colorsSemanticNegative500);
        font-weight: var(--fontWeights700);
        margin-left: var(--spacing050);
      }
    `}

  ${({
  disabled
}) => disabled && (0, _styledComponents.css)`
      color: var(--colorsUtilityYin030);
    `}
`;
const DEFAULT_CONTAINER_WIDTH = 30;
const StyledLabelContainer = exports.StyledLabelContainer = _styledComponents.default.div`
  display: flex;
  align-items: center;
  margin-bottom: 8px;

  ${({
  align,
  inline,
  pr,
  pl,
  width
}) => inline && (0, _styledComponents.css)`
      box-sizing: border-box;
      margin-bottom: 0;
      ${pr && (0, _styledComponents.css)`
        padding-right: var(${pr === 1 ? "--spacing100" : "--spacing200"});
      `};
      ${pl && (0, _styledComponents.css)`
        padding-left: var(${pl === 1 ? "--spacing100" : "--spacing200"});
      `};
      justify-content: ${align === "right" ? "flex-end" : "flex-start"};
      width: ${width || DEFAULT_CONTAINER_WIDTH}%;
    `}

  ${({
  optional
}) => optional && (0, _styledComponents.css)`
      ::after {
        content: "(optional)";
        font-weight: var(--fontWeights400);
        margin-left: var(--spacing050);
        color: var(--colorsUtilityYin055);
      }
    `}
`;
var _default = exports.default = StyledLabel;