"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Label = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _help = _interopRequireDefault(require("../../components/help"));
var _label = _interopRequireWildcard(require("./label.style"));
var _validationIcon = _interopRequireDefault(require("../validations/validation-icon.component"));
var _iconWrapper = _interopRequireDefault(require("./icon-wrapper.style"));
var _inputBehaviour = require("../input-behaviour");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const shouldDisplayValidationIcon = ({
  error,
  warning,
  info,
  disabled
}) => {
  const validation = error || warning || info;
  return disabled ? false : typeof validation === "string";
};
const tooltipPosition = ({
  error,
  warning,
  info,
  inline
}) => {
  return (error || warning || info) && inline ? "top" : "right";
};
const Label = ({
  align = "right",
  as = "label",
  children,
  disabled,
  error,
  help,
  helpIcon,
  htmlFor,
  info,
  inline,
  isRequired,
  labelId,
  optional,
  pr,
  pl,
  tooltipId,
  useValidationIcon = true,
  validationIconId,
  warning,
  width = 30,
  className,
  "aria-label": ariaLabel
}) => {
  const [isFocused, setFocus] = (0, _react.useState)(false);
  const {
    onMouseEnter,
    onMouseLeave
  } = (0, _react.useContext)(_inputBehaviour.InputContext);
  const {
    onMouseEnter: onGroupMouseEnter,
    onMouseLeave: onGroupMouseLeave
  } = (0, _react.useContext)(_inputBehaviour.InputGroupContext);
  const handleMouseEnter = () => {
    if (onMouseEnter) onMouseEnter();
    if (onGroupMouseEnter) onGroupMouseEnter();
  };
  const handleMouseLeave = () => {
    if (onMouseLeave) onMouseLeave();
    if (onGroupMouseLeave) onGroupMouseLeave();
  };
  const icon = () => {
    const wrapperProps = {
      onFocus: () => setFocus(true),
      onBlur: () => setFocus(false)
    };
    if (useValidationIcon && shouldDisplayValidationIcon({
      error,
      warning,
      info,
      disabled
    })) {
      const tooltipPositionValue = tooltipPosition({
        error,
        warning,
        info,
        inline
      });
      return /*#__PURE__*/_react.default.createElement(_iconWrapper.default, null, /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
        tooltipId: validationIconId,
        error: error,
        warning: warning,
        info: info,
        tooltipPosition: tooltipPositionValue,
        tooltipFlipOverrides: ["top", "bottom"]
      }));
    }
    return help && /*#__PURE__*/_react.default.createElement(_iconWrapper.default, wrapperProps, /*#__PURE__*/_react.default.createElement(_help.default, {
      tooltipId: tooltipId,
      type: helpIcon,
      isFocused: isFocused
    }, help));
  };
  return /*#__PURE__*/_react.default.createElement(_label.StyledLabelContainer, {
    align: align,
    inline: inline,
    width: width,
    optional: optional,
    pr: pr,
    pl: pl,
    className: className
  }, /*#__PURE__*/_react.default.createElement(_label.default, _extends({
    "data-element": "label",
    disabled: disabled,
    id: labelId
  }, as === "label" ? {
    htmlFor
  } : {}, {
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    isRequired: isRequired,
    as: as,
    "aria-label": ariaLabel
  }), children), icon());
};
exports.Label = Label;
var _default = exports.default = /*#__PURE__*/_react.default.memo(Label);