import React from "react";
import { StyledLabelProps, StyledLabelContainerProps } from "./label.style";
import { ValidationProps } from "../validations";
import { IconType } from "../../components/icon";
export interface LabelProps extends ValidationProps, StyledLabelProps, StyledLabelContainerProps {
    as?: "span" | "label";
    /** Children elements */
    children?: React.ReactNode;
    /** A message that the Help component will display */
    help?: React.ReactNode;
    /** Icon type */
    helpIcon?: IconType;
    /** A string that represents the ID of another form element */
    htmlFor?: string;
    /** The unique id of the label element */
    labelId?: string;
    /** The unique id of the Help component tooltip, used for accessibility */
    tooltipId?: string;
    /** Whether to show the validation icon */
    useValidationIcon?: boolean;
    /** Id of the validation icon */
    validationIconId?: string;
    /** Sets className for component */
    className?: string;
    /** Sets aria-label for label element */
    "aria-label"?: string;
}
export declare const Label: ({ align, as, children, disabled, error, help, helpIcon, htmlFor, info, inline, isRequired, labelId, optional, pr, pl, tooltipId, useValidationIcon, validationIconId, warning, width, className, "aria-label": ariaLabel, }: LabelProps) => React.JSX.Element;
declare const _default: React.MemoExoticComponent<({ align, as, children, disabled, error, help, helpIcon, htmlFor, info, inline, isRequired, labelId, optional, pr, pl, tooltipId, useValidationIcon, validationIconId, warning, width, className, "aria-label": ariaLabel, }: LabelProps) => React.JSX.Element>;
export default _default;
