import React from "react";
import { BorderRadiusType } from "../../components/box/box.component";
export declare type EnterKeyHintTypes = "enter" | "done" | "go" | "next" | "previous" | "search" | "send";
export interface CommonInputProps extends Omit<React.InputHTMLAttributes<HTMLInputElement>, "type"> {
    align?: "right" | "left";
    /** The id of the element that describe the input. */
    ariaDescribedBy?: string;
    /** Override the variant component */
    as?: React.ElementType;
    /** If true the Component will be focused when rendered */
    autoFocus?: boolean;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** HTML id attribute of the input */
    id?: string;
    /** Specify a custom border radius for the input. Any valid border-radius design token, or an array of border-radius design tokens. */
    inputBorderRadius?: BorderRadiusType | BorderRadiusType[];
    /** Name of the input */
    name?: string;
    /** Specify a callback triggered on blur */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on change */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on click */
    onClick?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on focus */
    onFocus?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on keyDown */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Placeholder string to be displayed in input */
    placeholder?: string;
    /** If true, the component will be read-only */
    readOnly?: boolean;
    /** Flag to configure component as mandatory */
    required?: boolean;
    /** Id of the validation icon */
    validationIconId?: string;
}
export interface InputProps extends CommonInputProps {
    /** The visible width of the text control, in average character widths */
    cols?: number;
    /** Integer to determine a timeout for the deferred callback */
    deferTimeout?: number;
    /** Deferred callback to be called after the onChange event */
    onChangeDeferred?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** The number of visible text lines for the control */
    rows?: number;
    /** HTML type attribute of the input */
    type?: string;
}
declare const Input: React.ForwardRefExoticComponent<InputProps & React.RefAttributes<HTMLInputElement | HTMLTextAreaElement>>;
export default Input;
