"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledInputPresentationContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _inputSizes = _interopRequireDefault(require("./input-sizes.style"));
var _input = _interopRequireDefault(require("./input.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledInputPresentationContainer = exports.StyledInputPresentationContainer = _styledComponents.default.div`
  flex: 0 0 ${({
  inputWidth
}) => inputWidth}%;
  display: flex;
  position: relative;
  max-width: ${({
  maxWidth
}) => maxWidth ? `${maxWidth}` : "100%"};
`;
function stylingForValidations({
  error,
  warning,
  info,
  disabled,
  validationRedesignOptIn
}) {
  let validationColor;
  if (disabled) {
    return "";
  }
  if (error) {
    validationColor = "var(--colorsSemanticNegative500)";
  } else if (warning) {
    validationColor = validationRedesignOptIn ? "var(--colorsUtilityMajor300)" : "var(--colorsSemanticCaution500)";
  } else if (info) {
    validationColor = "var(--colorsSemanticInfo500)";
  } else {
    return "";
  }
  return (0, _styledComponents.css)`
    border-color: ${validationColor} !important;
    z-index: 1;
    ${error && `box-shadow: inset 1px 1px 0 ${validationColor}, inset -1px -1px 0 ${validationColor};`}
  `;
}
const InputPresentationStyle = _styledComponents.default.div`
  align-items: stretch;
  background: var(--colorsUtilityYang100);
  ${({
  hideBorders
}) => hideBorders ? `border: 1px solid transparent;` : `border: 1px solid var(--colorsUtilityMajor300);`}
  box-sizing: border-box;
  cursor: text;
  display: flex;
  flex-wrap: wrap;
  width: 100%;
  margin: 0;

  ${({
  borderRadius
}) => {
  if (Array.isArray(borderRadius)) {
    return `border-radius: ${borderRadius.map(value => `var(--${value})`).join(" ")};`;
  }
  return `border-radius: var(--${borderRadius});`;
}}

  ${({
  size,
  hasIcon,
  align
}) => size && (0, _styledComponents.css)`
      min-height: ${_inputSizes.default[size].height};

      ${_input.default} {
        padding: 0 ${_inputSizes.default[size].horizontalPadding};
        ${hasIcon && align === "right" && "padding-left: 0;"}
        ${hasIcon && align === "left" && "padding-right: 0;"}
      }
    `}

  ${({
  disabled,
  hideBorders
}) => disabled && (0, _styledComponents.css)`
      background: var(--colorsUtilityDisabled400);
      border-color: ${hideBorders ? `transparent` : `var(--colorsUtilityDisabled600)`};
      cursor: not-allowed;
    `}

    ${({
  hasFocus,
  theme
}) => hasFocus && (0, _styledComponents.css)`
      & {
        ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
        z-index: 2;
      }
    `}

  ${stylingForValidations}

  ${({
  readOnly,
  hideBorders
}) => readOnly && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityReadOnly400);
      border-color: ${hideBorders ? `transparent` : `var(--colorsUtilityReadOnly600)`};
    `}

  ${({
  align,
  prefix
}) => align === "right" && `flex-direction: ${prefix ? "row" : "row-reverse"};
  `}

  input::-ms-clear {
    display: none;
  }
  input::-webkit-contacts-auto-fill-button {
    display: none !important;
  }
`;
var _default = exports.default = InputPresentationStyle;