"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _inputPresentation = _interopRequireWildcard(require("./input-presentation.style"));
var _inputBehaviour = require("../input-behaviour");
var _carbonProvider = require("../../components/carbon-provider/carbon-provider.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InputPresentation = ({
  align,
  borderRadius = "borderRadius050",
  children,
  disabled,
  error,
  hasIcon,
  hideBorders = false,
  info,
  inputWidth,
  maxWidth,
  positionedChildren,
  prefix,
  readOnly,
  size = "medium",
  warning
}) => {
  const {
    hasFocus,
    onMouseDown,
    onMouseEnter,
    onMouseLeave
  } = (0, _react.useContext)(_inputBehaviour.InputContext);
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const {
    onMouseEnter: onGroupMouseEnter,
    onMouseLeave: onGroupMouseLeave
  } = (0, _react.useContext)(_inputBehaviour.InputGroupContext);
  const handleMouseEnter = () => {
    if (onMouseEnter) onMouseEnter();
    if (onGroupMouseEnter) onGroupMouseEnter();
  };
  const handleMouseLeave = () => {
    if (onMouseLeave) onMouseLeave();
    if (onGroupMouseLeave) onGroupMouseLeave();
  };
  return /*#__PURE__*/_react.default.createElement(_inputPresentation.StyledInputPresentationContainer, {
    inputWidth: inputWidth,
    maxWidth: maxWidth
  }, positionedChildren, /*#__PURE__*/_react.default.createElement(_inputPresentation.default, {
    hasFocus: hasFocus,
    role: "presentation",
    onMouseDown: onMouseDown,
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    align: align,
    prefix: prefix,
    disabled: disabled,
    readOnly: readOnly,
    size: size,
    warning: warning,
    error: error,
    info: info,
    validationRedesignOptIn: validationRedesignOptIn,
    hasIcon: hasIcon,
    borderRadius: borderRadius,
    hideBorders: hideBorders
  }, children));
};
if (process.env.NODE_ENV !== "production") {
  InputPresentation.propTypes = {
    "align": _propTypes.default.string,
    "borderRadius": _propTypes.default.any,
    "children": _propTypes.default.node,
    "disabled": _propTypes.default.bool,
    "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "hasIcon": _propTypes.default.bool,
    "hideBorders": _propTypes.default.bool,
    "info": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "inputWidth": _propTypes.default.number,
    "maxWidth": _propTypes.default.string,
    "positionedChildren": _propTypes.default.node,
    "prefix": _propTypes.default.string,
    "readOnly": _propTypes.default.bool,
    "size": _propTypes.default.oneOf(["large", "medium", "small"]),
    "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool])
  };
}
var _default = exports.default = InputPresentation;