import React from "react";
import { BorderRadiusType } from "../../components/box/box.component";
import { ValidationProps } from "../validations";
export declare type Sizes = "small" | "medium" | "large";
export interface CommonInputPresentationProps extends ValidationProps {
    children: React.ReactNode;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** The default value alignment on the input */
    align?: string;
    /** Emphasized part of the displayed text */
    prefix?: string;
    /** The width of the input as a percentage */
    inputWidth?: number;
    /**
     * Prop for specifying the max-width of the input.
     * Leaving the `maxWidth` prop with no value will default the width to '100%'
     */
    maxWidth?: string;
    /** If true, the component will be read-only */
    readOnly?: boolean;
    /** Size of an input */
    size?: Sizes;
    /** If true, the component has an icon rendered inside */
    hasIcon?: boolean;
    /** Specify a custom border radius. Any valid border-radius design token, or an array of border-radius design tokens. */
    borderRadius?: BorderRadiusType | BorderRadiusType[];
    /** Renders with transparent borders. This will not effect focus styling or validation borders  */
    hideBorders?: boolean;
}
export interface InputPresentationProps extends CommonInputPresentationProps {
    /** Content to be rendered before the input */
    positionedChildren?: React.ReactNode;
}
declare const InputPresentation: ({ align, borderRadius, children, disabled, error, hasIcon, hideBorders, info, inputWidth, maxWidth, positionedChildren, prefix, readOnly, size, warning, }: InputPresentationProps) => JSX.Element;
export default InputPresentation;
