"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _inputSizes = _interopRequireDefault(require("../input/input-sizes.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const InputIconToggleStyle = _styledComponents.default.span.attrs(({
  onClick
}) => ({
  onKeyDown: event => {
    if (onClick && (event.key === " " || event.key === "Enter")) {
      event.preventDefault();
      return onClick(event);
    }
    return event;
  }
}))`
  align-items: center;
  cursor: pointer;
  display: flex;
  justify-content: center;

  ${({
  size = "medium"
}) => (0, _styledComponents.css)`
    width: ${_inputSizes.default[size].height};
  `}

  ${({
  disabled
}) => disabled && (0, _styledComponents.css)`
      cursor: not-allowed;
    `}
  
  ${({
  readOnly
}) => readOnly && (0, _styledComponents.css)`
      cursor: default;
    `}

  ${({
  theme
}) => `
    &:focus {
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
    }  
  `}
`;
var _default = exports.default = InputIconToggleStyle;