"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _icon = _interopRequireDefault(require("../../components/icon"));
var _inputIconToggle = _interopRequireDefault(require("./input-icon-toggle.style"));
var _validationIcon = _interopRequireDefault(require("../validations/validation-icon.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const shouldDisplayValidationIcon = ({
  error,
  warning,
  info
}) => {
  const validation = error || warning || info || null;
  return typeof validation === "string";
};
const InputIconToggle = ({
  disabled,
  readOnly,
  size,
  inputIcon: type,
  onClick,
  onFocus,
  onBlur,
  onMouseDown,
  error,
  warning,
  info,
  useValidationIcon,
  align,
  iconTabIndex,
  validationIconId
}) => {
  if (useValidationIcon && !disabled && shouldDisplayValidationIcon({
    error,
    warning,
    info
  })) {
    return /*#__PURE__*/_react.default.createElement(_inputIconToggle.default, {
      size: size
    }, /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
      error: error,
      warning: warning,
      info: info,
      size: size,
      onClick: onClick,
      onFocus: onFocus,
      onBlur: onBlur,
      isPartOfInput: true,
      tabIndex: iconTabIndex,
      tooltipId: validationIconId,
      tooltipPosition: align === "right" ? "left" : "right"
    }));
  }
  if (type) {
    return /*#__PURE__*/_react.default.createElement(_inputIconToggle.default, {
      size: size,
      onClick: onClick,
      onFocus: onFocus,
      onBlur: onBlur,
      onMouseDown: onMouseDown,
      tabIndex: iconTabIndex,
      "data-element": "input-icon-toggle",
      disabled: disabled,
      readOnly: readOnly
    }, /*#__PURE__*/_react.default.createElement(_icon.default, {
      disabled: disabled || readOnly,
      type: type
    }));
  }
  return null;
};
var _default = exports.default = InputIconToggle;