"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
const useInputBehaviour = blockGroupBehaviour => {
  const [hasFocus, setHasFocus] = (0, _react.useState)(false);
  const [hasMouseOver, setHasMouseOver] = (0, _react.useState)(false);
  const inputRef = (0, _react.useRef)(null);
  const onFocus = (0, _react.useCallback)(() => setHasFocus(true), []);
  const onBlur = (0, _react.useCallback)(() => setHasFocus(false), []);
  const assignInput = (0, _react.useCallback)(input => {
    inputRef.current = input.current;
  }, []);

  // use mouse down rather than click to accommodate click and drag events too
  const onMouseDown = (0, _react.useCallback)(() => {
    requestAnimationFrame(() => {
      inputRef?.current?.focus({
        preventScroll: true
      });
    });
  }, []);
  const onMouseEnter = (0, _react.useCallback)(() => setHasMouseOver(true), []);
  const onMouseLeave = (0, _react.useCallback)(() => setHasMouseOver(false), []);
  const contextValue = (0, _react.useMemo)(() => ({
    hasFocus,
    hasMouseOver,
    onFocus: blockGroupBehaviour ? undefined : onFocus,
    onBlur: blockGroupBehaviour ? undefined : onBlur,
    onMouseDown,
    onMouseEnter: blockGroupBehaviour ? undefined : onMouseEnter,
    onMouseLeave: blockGroupBehaviour ? undefined : onMouseLeave,
    inputRef: assignInput
  }), [hasFocus, hasMouseOver, onFocus, onBlur, onMouseDown, blockGroupBehaviour, onMouseEnter, onMouseLeave, assignInput]);
  return contextValue;
};
var _default = exports.default = useInputBehaviour;