"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _formField = _interopRequireWildcard(require("./form-field.style"));
var _label = _interopRequireDefault(require("../label"));
var _fieldHelp = _interopRequireDefault(require("../field-help"));
var _tags = _interopRequireDefault(require("../utils/helpers/tags/tags"));
var _tab = require("../../components/tabs/tab");
var _useIsAboveBreakpoint = _interopRequireDefault(require("../../hooks/__internal__/useIsAboveBreakpoint"));
var _useFormSpacing = _interopRequireDefault(require("../../hooks/__internal__/useFormSpacing"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FormField = ({
  children,
  "data-component": dataComponent,
  disabled,
  loading,
  fieldHelp: fieldHelpContent,
  fieldHelpInline,
  error,
  warning,
  info,
  tooltipId,
  fieldHelpId,
  label,
  labelId,
  labelAlign,
  labelHelp,
  labelHelpIcon,
  labelInline,
  labelSpacing = 2,
  labelWidth,
  labelAs,
  id,
  reverse,
  isOptional,
  useValidationIcon,
  adaptiveLabelBreakpoint,
  isRequired,
  validationIconId,
  validationRedesignOptIn,
  ...rest
}) => {
  const invalidValidationProp = (0, _react.useMemo)(() => {
    const validationProps = {
      error: !!error,
      warning: !!warning,
      info: !!info
    };
    if (!(disabled && !loading)) return undefined;
    return Object.keys(validationProps).find(propName => validationProps[propName]);
  }, [error, warning, info, disabled]);
  !(invalidValidationProp === undefined) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `Prop \`${invalidValidationProp}\` cannot be used in conjunction with \`disabled\`. ` + "Use `readOnly` if you require users to see validations with a non-interactive field") : (0, _invariant.default)(false) : void 0;
  !!(isRequired && isOptional) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "an input cannot be set to both required and optional at the same time") : (0, _invariant.default)(false) : void 0;
  const largeScreen = (0, _useIsAboveBreakpoint.default)(adaptiveLabelBreakpoint);
  let inlineLabel = labelInline;
  if (adaptiveLabelBreakpoint) {
    inlineLabel = largeScreen;
  }
  const {
    setError,
    setWarning,
    setInfo
  } = (0, _react.useContext)(_tab.TabContext);
  const marginProps = (0, _useFormSpacing.default)(rest);
  const isMounted = (0, _react.useRef)(false);
  (0, _react.useLayoutEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    if (setError) setError(id, error);
    if (setWarning) setWarning(id, warning);
    if (setInfo) setInfo(id, info);
    return () => {
      if (!isMounted.current) {
        if (setError && error) setError(id, false);
        if (setWarning && warning) setWarning(id, false);
        if (setInfo && info) setInfo(id, false);
      }
    };
  }, [id, setError, setWarning, setInfo, error, warning, info]);
  const fieldHelp = fieldHelpContent ? /*#__PURE__*/_react.default.createElement(_fieldHelp.default, {
    labelInline: inlineLabel,
    labelWidth: labelWidth,
    id: fieldHelpId
  }, fieldHelpContent) : null;
  return /*#__PURE__*/_react.default.createElement(_formField.default, _extends({}, (0, _tags.default)(dataComponent, rest), marginProps), /*#__PURE__*/_react.default.createElement(_formField.FieldLineStyle, {
    inline: inlineLabel
  }, reverse && children, label && /*#__PURE__*/_react.default.createElement(_label.default, {
    labelId: labelId,
    align: labelAlign,
    disabled: disabled,
    error: !validationRedesignOptIn && error,
    warning: !validationRedesignOptIn && warning,
    info: !validationRedesignOptIn && info,
    help: labelHelp,
    tooltipId: tooltipId,
    htmlFor: id,
    helpIcon: labelHelpIcon,
    inline: inlineLabel,
    width: labelWidth,
    optional: isOptional,
    useValidationIcon: useValidationIcon,
    pr: !reverse ? labelSpacing : undefined,
    pl: reverse ? labelSpacing : undefined,
    isRequired: isRequired,
    validationIconId: validationIconId,
    as: labelAs
  }, label), fieldHelpInline && fieldHelp, !reverse && children), !fieldHelpInline && fieldHelp);
};
FormField.displayName = "FormField";
var _default = exports.default = FormField;