"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TAB_GUARD_TOP = exports.TAB_GUARD_BOTTOM = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _focusTrapUtils = require("./focus-trap-utils");
var _modal = require("../../components/modal/modal.component");
var _usePrevious = _interopRequireDefault(require("../../hooks/__internal__/usePrevious"));
var _topModalContext = _interopRequireDefault(require("../../components/carbon-provider/top-modal-context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAB_GUARD_TOP = exports.TAB_GUARD_TOP = "tab-guard-top";
const TAB_GUARD_BOTTOM = exports.TAB_GUARD_BOTTOM = "tab-guard-bottom";

// TODO investigate why React.RefObject<T> produces a failed prop type when current = null

const FocusTrap = ({
  children,
  autoFocus = true,
  focusableSelectors,
  focusFirstElement,
  bespokeTrap,
  wrapperRef,
  isOpen,
  additionalWrapperRefs
}) => {
  const trapRef = (0, _react.useRef)(null);
  const [currentFocusedElement, setCurrentFocusedElement] = (0, _react.useState)();
  const {
    isAnimationComplete = true,
    triggerRefocusFlag
  } = (0, _react.useContext)(_modal.ModalContext);
  const {
    topModal
  } = (0, _react.useContext)(_topModalContext.default);
  // we ensure that isTopModal is true if there is no TopModalContext, so that consumers who have not
  // wrapped their app in CarbonProvider do not have all FocusTrap behaviour broken
  const isTopModal = !topModal || wrapperRef.current && topModal.contains(wrapperRef.current);
  const trapWrappers = (0, _react.useMemo)(() => additionalWrapperRefs?.length ? [wrapperRef, ...additionalWrapperRefs] : [wrapperRef], [additionalWrapperRefs, wrapperRef]);
  const onTabGuardTopFocus = (0, _react.useMemo)(() => (0, _focusTrapUtils.onTabGuardFocus)(trapWrappers, focusableSelectors, "top"), [focusableSelectors, trapWrappers]);
  const onTabGuardBottomFocus = (0, _react.useMemo)(() => (0, _focusTrapUtils.onTabGuardFocus)(trapWrappers, focusableSelectors, "bottom"), [focusableSelectors, trapWrappers]);
  (0, _react.useEffect)(() => {
    additionalWrapperRefs?.forEach(ref => {
      const {
        current: containerElement
      } = ref;
      // istanbul ignore else
      if (containerElement) {
        // istanbul ignore else
        if (!containerElement.previousElementSibling?.matches(`[data-element=${TAB_GUARD_TOP}]`)) {
          const topTabGuard = document.createElement("div");
          topTabGuard.tabIndex = 0;
          topTabGuard.dataset.element = TAB_GUARD_TOP;
          containerElement.insertAdjacentElement("beforebegin", topTabGuard);
          topTabGuard.addEventListener("focus", onTabGuardTopFocus(ref));
        }
        // istanbul ignore else
        if (!containerElement.nextElementSibling?.matches(`[data-element=${TAB_GUARD_BOTTOM}]`)) {
          const bottomTabGuard = document.createElement("div");
          bottomTabGuard.tabIndex = 0;
          bottomTabGuard.dataset.element = TAB_GUARD_BOTTOM;
          containerElement.insertAdjacentElement("afterend", bottomTabGuard);
          bottomTabGuard.addEventListener("focus", onTabGuardBottomFocus(ref));
        }
      }
    });
    return () => {
      additionalWrapperRefs?.forEach(ref => {
        const previousElement = ref.current?.previousElementSibling;
        if (previousElement?.matches(`[data-element=${TAB_GUARD_TOP}]`)) {
          previousElement.remove();
        }
        const nextElement = ref.current?.nextElementSibling;
        if (nextElement?.matches(`[data-element=${TAB_GUARD_BOTTOM}]`)) {
          nextElement.remove();
        }
      });
    };
  }, [additionalWrapperRefs, onTabGuardTopFocus, onTabGuardBottomFocus]);
  const shouldSetFocus = autoFocus && isOpen && isAnimationComplete;
  const prevShouldSetFocus = (0, _usePrevious.default)(shouldSetFocus);
  const getFocusableElements = (0, _react.useCallback)(selector => {
    const elements = [];
    trapWrappers.forEach(ref => {
      // istanbul ignore else
      if (ref.current) {
        elements.push(...Array.from(ref.current.querySelectorAll(selector)).filter(el => Number(el.tabIndex) !== -1));
      }
    });
    return elements;
  }, [trapWrappers]);
  (0, _react.useEffect)(() => {
    if (shouldSetFocus && !prevShouldSetFocus) {
      const candidateFirstElement = focusFirstElement && "current" in focusFirstElement ? focusFirstElement.current : focusFirstElement;
      const autoFocusedElement = getFocusableElements(_focusTrapUtils.defaultFocusableSelectors).find(el => el.getAttribute("data-has-autofocus") === "true");
      const elementToFocus = candidateFirstElement || autoFocusedElement || wrapperRef.current;
      // istanbul ignore else
      if (elementToFocus) {
        (0, _focusTrapUtils.setElementFocus)(elementToFocus);
      }
    }
  }, [shouldSetFocus, prevShouldSetFocus, getFocusableElements, focusFirstElement, wrapperRef]);
  (0, _react.useEffect)(() => {
    const trapFn = ev => {
      // block focus trap from working if it's not the topmost trap, or is currently closed
      if (!isTopModal || !isOpen) {
        return;
      }
      const focusableElements = getFocusableElements(_focusTrapUtils.defaultFocusableSelectors);
      (0, _focusTrapUtils.trapFunction)(ev, focusableElements, document.activeElement === wrapperRef.current, focusableSelectors, bespokeTrap);
    };
    document.addEventListener("keydown", trapFn, true);
    return function cleanup() {
      document.removeEventListener("keydown", trapFn, true);
    };
  }, [bespokeTrap, wrapperRef, focusableSelectors, getFocusableElements, isTopModal, isOpen]);
  const updateCurrentFocusedElement = (0, _react.useCallback)(() => {
    const focusableElements = getFocusableElements(focusableSelectors || _focusTrapUtils.defaultFocusableSelectors);
    const element = focusableElements?.find(el => el === document.activeElement);
    if (element) {
      setCurrentFocusedElement(element);
    }
  }, [getFocusableElements, focusableSelectors]);
  const refocusTrap = (0, _react.useCallback)(() => {
    if (currentFocusedElement && !currentFocusedElement.hasAttribute("disabled")) {
      // the trap breaks if it tries to refocus a disabled element
      (0, _focusTrapUtils.setElementFocus)(currentFocusedElement);
    } else if (wrapperRef.current?.hasAttribute("tabindex")) {
      (0, _focusTrapUtils.setElementFocus)(wrapperRef.current);
    } else {
      const focusableElements = getFocusableElements(focusableSelectors || _focusTrapUtils.defaultFocusableSelectors);
      /* istanbul ignore else */
      if (focusableElements.length) {
        (0, _focusTrapUtils.setElementFocus)(focusableElements[0]);
      }
    }
  }, [currentFocusedElement, wrapperRef, focusableSelectors, getFocusableElements]);
  (0, _react.useEffect)(() => {
    if (triggerRefocusFlag) {
      refocusTrap();
    }
  }, [triggerRefocusFlag, refocusTrap]);
  const [tabIndex, setTabIndex] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    // tabIndex is set to 0 and removed on blur.
    if (!isOpen) {
      setTabIndex(0);
    }
  }, [isOpen]);
  const onBlur = () => {
    /* istanbul ignore else */
    if (isOpen) {
      setTabIndex(undefined);
    }
  };
  const focusProps = hasNoTabIndex => ({
    ...(hasNoTabIndex && {
      tabIndex,
      onBlur
    }),
    onFocus: updateCurrentFocusedElement
  });

  // passes focusProps, sets tabIndex and onBlur if no tabIndex has been expicitly set on child
  const clonedChildren = _react.default.Children.map(children, child => {
    const focusableChild = child;
    return /*#__PURE__*/_react.default.cloneElement(focusableChild, focusProps(focusableChild?.props?.tabIndex === undefined));
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: trapRef
  }, isOpen && /*#__PURE__*/_react.default.createElement("div", {
    "data-element": TAB_GUARD_TOP
    // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: 0,
    onFocus: onTabGuardTopFocus(wrapperRef)
  }), clonedChildren, isOpen && /*#__PURE__*/_react.default.createElement("div", {
    "data-element": TAB_GUARD_BOTTOM
    // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: 0,
    onFocus: onTabGuardBottomFocus(wrapperRef)
  }));
};
var _default = exports.default = FocusTrap;