import React from "react";
export declare const TAB_GUARD_TOP = "tab-guard-top";
export declare const TAB_GUARD_BOTTOM = "tab-guard-bottom";
export declare type CustomRefObject<T> = {
    current?: T | null;
};
export interface FocusTrapProps {
    children: React.ReactNode;
    autoFocus?: boolean;
    /** provide a custom first element to focus */
    focusFirstElement?: CustomRefObject<HTMLElement> | HTMLElement | null;
    /** a custom callback that will override the default focus trap behaviour */
    bespokeTrap?: (ev: KeyboardEvent, firstElement?: HTMLElement, lastElement?: HTMLElement) => void;
    /** optional selector to identify the focusable elements, if not provided a default selector is used */
    focusableSelectors?: string;
    /** a ref to the container wrapping the focusable elements */
    wrapperRef: CustomRefObject<HTMLElement>;
    isOpen?: boolean;
    /** an optional array of refs to containers whose content should also be reachable from the FocusTrap */
    additionalWrapperRefs?: CustomRefObject<HTMLElement>[];
}
declare const FocusTrap: ({ children, autoFocus, focusableSelectors, focusFirstElement, bespokeTrap, wrapperRef, isOpen, additionalWrapperRefs, }: FocusTrapProps) => React.JSX.Element;
export default FocusTrap;
