"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledLegendContent = exports.StyledLegend = exports.StyledFieldset = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFieldset = exports.StyledFieldset = _styledComponents.default.fieldset`
  margin: 0;
  ${_styledSystem.margin}
  border: none;
  padding: 0;
  min-width: 0;
  min-inline-size: 0;
  ${({
  width
}) => width && `width: ${width};`}
`;
StyledFieldset.defaultProps = {
  theme: _base.default
};
const StyledLegendContent = exports.StyledLegendContent = _styledComponents.default.span`
  display: flex;
  align-items: center;
  line-height: 24px;
  ${({
  isRequired
}) => isRequired && (0, _styledComponents.css)`
      ::after {
        content: "*";
        line-height: 24px;
        color: var(--colorsSemanticNegative500);
        font-weight: var(--fontWeights700);
        margin-left: var(--spacing050);
        position: relative;
        top: 1px;
      }
    `}

  ${({
  isOptional
}) => isOptional && (0, _styledComponents.css)`
      ::after {
        content: "(optional)";
        color: var(--colorsUtilityYin055);
        font-weight: var(--fontWeights400);
        margin-left: var(--spacing050);
      }
    `}

  ${({
  isDisabled
}) => isDisabled && (0, _styledComponents.css)`
      color: var(--colorsUtilityYin030);
      ::after {
        color: var(--colorsUtilityYin030);
      }
    `}
`;
const StyledLegend = exports.StyledLegend = _styledComponents.default.legend`
  display: flex;
  align-items: center;
  margin-bottom: var(--spacing100);
  padding: 0;
  font-weight: var(--fontWeights700);
  color: var(--colorsUtilityYin090);
  ${({
  inline,
  width,
  align,
  rightPadding
}) => inline && (0, _styledComponents.css)`
      float: left;
      box-sizing: border-box;
      margin: 0;
      ${width && `width: ${width}%`};
      justify-content: ${align === "right" ? "flex-end" : "flex-start"};
      padding-right: ${rightPadding === 1 ? "var(--spacing100)" : "var(--spacing200)"};
    `}
  ${_styledSystem.margin}
`;