"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _fieldset = require("./fieldset.style");
var _validationIcon = _interopRequireDefault(require("../validations/validation-icon.component"));
var _carbonProvider = require("../../components/carbon-provider/carbon-provider.component");
var _inputBehaviour = require("../input-behaviour");
var _useFormSpacing = _interopRequireDefault(require("../../hooks/__internal__/useFormSpacing"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Fieldset = ({
  legend,
  children,
  inline = false,
  legendWidth,
  legendAlign = "right",
  legendSpacing = 2,
  error,
  warning,
  info,
  isRequired,
  blockGroupBehaviour,
  legendMargin = {},
  isDisabled,
  isOptional,
  ...rest
}) => {
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const marginProps = (0, _useFormSpacing.default)(rest);
  const [ref, setRef] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (ref && isRequired) {
      Array.from(ref.querySelectorAll("input") || /* istanbul ignore next */[]).forEach(el => {
        el.setAttribute("required", "");
      });
    }
  }, [ref, isRequired]);
  return /*#__PURE__*/_react.default.createElement(_inputBehaviour.InputGroupBehaviour, {
    blockGroupBehaviour: blockGroupBehaviour
  }, /*#__PURE__*/_react.default.createElement(_fieldset.StyledFieldset, _extends({
    ref: setRef,
    "data-component": "fieldset"
  }, rest, marginProps), legend && /*#__PURE__*/_react.default.createElement(_inputBehaviour.InputGroupContext.Consumer, null, ({
    onMouseEnter,
    onMouseLeave
  }) => /*#__PURE__*/_react.default.createElement(_fieldset.StyledLegend, _extends({
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    inline: inline,
    width: legendWidth,
    align: legendAlign,
    rightPadding: legendSpacing
  }, legendMargin, {
    "data-element": "legend"
  }), /*#__PURE__*/_react.default.createElement(_fieldset.StyledLegendContent, {
    isRequired: isRequired,
    isOptional: isOptional,
    isDisabled: isDisabled
  }, legend, !validationRedesignOptIn && /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
    error: error,
    warning: warning,
    info: info,
    tooltipFlipOverrides: ["top", "bottom"]
  })))), children));
};
var _default = exports.default = Fieldset;