import React from "react";
import { MarginProps } from "styled-system";
export interface FieldsetProps extends MarginProps {
    /** Role */
    role?: string;
    /** Fieldset content */
    children: React.ReactNode;
    /** The content for the Fieldset Legend */
    legend?: string;
    error?: boolean | string;
    warning?: boolean | string;
    info?: boolean | string;
    /** When true, legend is placed in line with the children */
    inline?: boolean;
    /** Percentage width of legend (only when legend is inline)  */
    legendWidth?: number;
    /** Text alignment of legend when inline */
    legendAlign?: "left" | "right";
    /** Spacing between legend and field for inline legend, number multiplied by base spacing unit (8) */
    legendSpacing?: 1 | 2;
    /** If true, an asterisk will be added to the label */
    isRequired?: boolean;
    /** Controls whether group behaviour should be enabled */
    blockGroupBehaviour?: boolean;
    /** Margin props for the legend element */
    legendMargin?: Pick<MarginProps, "mb">;
    /** Any valid CSS string to set the component's width */
    width?: string;
    /** Flag to configure component as optional in Form */
    isOptional?: boolean;
    /** Apply disabled styling to the legend content */
    isDisabled?: boolean;
    /** Set a name value on the component */
    name?: string;
    /** Set an id value on the component */
    id?: string;
}
declare const Fieldset: ({ legend, children, inline, legendWidth, legendAlign, legendSpacing, error, warning, info, isRequired, blockGroupBehaviour, legendMargin, isDisabled, isOptional, ...rest }: FieldsetProps) => React.JSX.Element;
export default Fieldset;
