"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _hiddenCheckableInput = _interopRequireDefault(require("./hidden-checkable-input.style"));
var _inputBehaviour = require("../input-behaviour");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const HiddenCheckableInput = /*#__PURE__*/_react.default.forwardRef(({
  ariaDescribedBy,
  ariaLabelledBy,
  name,
  checked,
  type,
  value,
  onChange,
  autoFocus,
  role,
  validationIconId,
  ...props
}, ref) => {
  const {
    onBlur,
    onFocus,
    onMouseEnter,
    onMouseLeave,
    hasFocus,
    hasMouseOver
  } = (0, _react.useContext)(_inputBehaviour.InputContext);
  const {
    onBlur: onBlurGroup,
    onFocus: onFocusGroup,
    onMouseEnter: onMouseEnterGroup,
    onMouseLeave: onMouseLeaveGroup,
    hasFocus: hasGroupFocus,
    hasMouseOver: hasGroupMouseOver
  } = (0, _react.useContext)(_inputBehaviour.InputGroupContext);
  const handleFocus = ev => {
    if (props.onFocus) props.onFocus(ev);
    if (onFocus) onFocus();
    if (onFocusGroup) onFocusGroup();
  };
  const handleBlur = ev => {
    if (props.onBlur) props.onBlur(ev);
    if (onBlur) onBlur();
    if (onBlurGroup) onBlurGroup();
  };
  const handleMouseEnter = ev => {
    if (props.onMouseEnter) props.onMouseEnter(ev);
    if (onMouseEnter) onMouseEnter();
    if (onMouseEnterGroup) onMouseEnterGroup();
  };
  const handleMouseLeave = ev => {
    if (props.onMouseLeave) props.onMouseLeave(ev);
    if (onMouseLeave) onMouseLeave();
    if (onMouseLeaveGroup) onMouseLeaveGroup();
  };
  const hasValidationPart = (hasFocus || hasGroupFocus || hasMouseOver || hasGroupMouseOver) && validationIconId;
  const descriptionList = ariaDescribedBy ? [ariaDescribedBy] : [];
  if (hasValidationPart) {
    descriptionList.push(validationIconId);
  }
  const combinedDescription = descriptionList.length ? descriptionList.filter(Boolean).join(" ") : undefined;
  return /*#__PURE__*/_react.default.createElement(_hiddenCheckableInput.default, _extends({
    "aria-describedby": combinedDescription,
    "aria-labelledby": ariaLabelledBy,
    autoFocus: autoFocus,
    "data-has-autofocus": autoFocus ? true : undefined,
    "aria-checked": checked,
    checked: checked,
    name: name,
    role: role || type,
    type: type,
    value: value
  }, props, {
    onFocus: handleFocus,
    onBlur: handleBlur,
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    onChange: onChange,
    ref: ref
  }));
});
if (process.env.NODE_ENV !== "production") {
  HiddenCheckableInput.propTypes = {
    "about": _propTypes.default.string,
    "accept": _propTypes.default.string,
    "accessKey": _propTypes.default.string,
    "alt": _propTypes.default.string,
    "aria-activedescendant": _propTypes.default.string,
    "aria-atomic": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-autocomplete": _propTypes.default.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-checked": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-colcount": _propTypes.default.number,
    "aria-colindex": _propTypes.default.number,
    "aria-colspan": _propTypes.default.number,
    "aria-controls": _propTypes.default.string,
    "aria-current": _propTypes.default.oneOfType([_propTypes.default.oneOf(["date", "false", "location", "page", "step", "time", "true"]), _propTypes.default.bool]),
    "aria-describedby": _propTypes.default.string,
    "aria-details": _propTypes.default.string,
    "aria-disabled": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-dropeffect": _propTypes.default.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": _propTypes.default.string,
    "aria-expanded": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-flowto": _propTypes.default.string,
    "aria-grabbed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-haspopup": _propTypes.default.oneOfType([_propTypes.default.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), _propTypes.default.bool]),
    "aria-hidden": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-invalid": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "grammar", "spelling", "true"]), _propTypes.default.bool]),
    "aria-keyshortcuts": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "aria-level": _propTypes.default.number,
    "aria-live": _propTypes.default.oneOf(["assertive", "off", "polite"]),
    "aria-modal": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiline": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiselectable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-orientation": _propTypes.default.oneOf(["horizontal", "vertical"]),
    "aria-owns": _propTypes.default.string,
    "aria-placeholder": _propTypes.default.string,
    "aria-posinset": _propTypes.default.number,
    "aria-pressed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-readonly": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-relevant": _propTypes.default.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-roledescription": _propTypes.default.string,
    "aria-rowcount": _propTypes.default.number,
    "aria-rowindex": _propTypes.default.number,
    "aria-rowspan": _propTypes.default.number,
    "aria-selected": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-setsize": _propTypes.default.number,
    "aria-sort": _propTypes.default.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": _propTypes.default.number,
    "aria-valuemin": _propTypes.default.number,
    "aria-valuenow": _propTypes.default.number,
    "aria-valuetext": _propTypes.default.string,
    "ariaDescribedBy": _propTypes.default.string,
    "ariaLabelledBy": _propTypes.default.string,
    "autoCapitalize": _propTypes.default.string,
    "autoComplete": _propTypes.default.string,
    "autoCorrect": _propTypes.default.string,
    "autoFocus": _propTypes.default.bool,
    "autoSave": _propTypes.default.string,
    "capture": _propTypes.default.oneOfType([_propTypes.default.oneOf(["environment", "user"]), _propTypes.default.bool]),
    "checked": _propTypes.default.bool,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "color": _propTypes.default.string,
    "content": _propTypes.default.string,
    "contentEditable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "inherit", "true"]), _propTypes.default.bool]),
    "contextMenu": _propTypes.default.string,
    "dangerouslySetInnerHTML": _propTypes.default.shape({
      "__html": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]).isRequired
    }),
    "datatype": _propTypes.default.string,
    "defaultChecked": _propTypes.default.bool,
    "defaultValue": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string), _propTypes.default.number, _propTypes.default.string]),
    "dir": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "draggable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "enterKeyHint": _propTypes.default.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "form": _propTypes.default.string,
    "formAction": _propTypes.default.string,
    "formEncType": _propTypes.default.string,
    "formMethod": _propTypes.default.string,
    "formNoValidate": _propTypes.default.bool,
    "formTarget": _propTypes.default.string,
    "height": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "hidden": _propTypes.default.bool,
    "id": _propTypes.default.string,
    "inlist": _propTypes.default.any,
    "inputMode": _propTypes.default.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "is": _propTypes.default.string,
    "itemID": _propTypes.default.string,
    "itemProp": _propTypes.default.string,
    "itemRef": _propTypes.default.string,
    "itemScope": _propTypes.default.bool,
    "itemType": _propTypes.default.string,
    "lang": _propTypes.default.string,
    "list": _propTypes.default.string,
    "max": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "maxLength": _propTypes.default.number,
    "min": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "minLength": _propTypes.default.number,
    "multiple": _propTypes.default.bool,
    "name": _propTypes.default.string,
    "nonce": _propTypes.default.string,
    "onAbort": _propTypes.default.func,
    "onAbortCapture": _propTypes.default.func,
    "onAnimationEnd": _propTypes.default.func,
    "onAnimationEndCapture": _propTypes.default.func,
    "onAnimationIteration": _propTypes.default.func,
    "onAnimationIterationCapture": _propTypes.default.func,
    "onAnimationStart": _propTypes.default.func,
    "onAnimationStartCapture": _propTypes.default.func,
    "onAuxClick": _propTypes.default.func,
    "onAuxClickCapture": _propTypes.default.func,
    "onBeforeInput": _propTypes.default.func,
    "onBeforeInputCapture": _propTypes.default.func,
    "onBlur": _propTypes.default.func,
    "onBlurCapture": _propTypes.default.func,
    "onCanPlay": _propTypes.default.func,
    "onCanPlayCapture": _propTypes.default.func,
    "onCanPlayThrough": _propTypes.default.func,
    "onCanPlayThroughCapture": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onChangeCapture": _propTypes.default.func,
    "onClick": _propTypes.default.func,
    "onClickCapture": _propTypes.default.func,
    "onCompositionEnd": _propTypes.default.func,
    "onCompositionEndCapture": _propTypes.default.func,
    "onCompositionStart": _propTypes.default.func,
    "onCompositionStartCapture": _propTypes.default.func,
    "onCompositionUpdate": _propTypes.default.func,
    "onCompositionUpdateCapture": _propTypes.default.func,
    "onContextMenu": _propTypes.default.func,
    "onContextMenuCapture": _propTypes.default.func,
    "onCopy": _propTypes.default.func,
    "onCopyCapture": _propTypes.default.func,
    "onCut": _propTypes.default.func,
    "onCutCapture": _propTypes.default.func,
    "onDoubleClick": _propTypes.default.func,
    "onDoubleClickCapture": _propTypes.default.func,
    "onDrag": _propTypes.default.func,
    "onDragCapture": _propTypes.default.func,
    "onDragEnd": _propTypes.default.func,
    "onDragEndCapture": _propTypes.default.func,
    "onDragEnter": _propTypes.default.func,
    "onDragEnterCapture": _propTypes.default.func,
    "onDragExit": _propTypes.default.func,
    "onDragExitCapture": _propTypes.default.func,
    "onDragLeave": _propTypes.default.func,
    "onDragLeaveCapture": _propTypes.default.func,
    "onDragOver": _propTypes.default.func,
    "onDragOverCapture": _propTypes.default.func,
    "onDragStart": _propTypes.default.func,
    "onDragStartCapture": _propTypes.default.func,
    "onDrop": _propTypes.default.func,
    "onDropCapture": _propTypes.default.func,
    "onDurationChange": _propTypes.default.func,
    "onDurationChangeCapture": _propTypes.default.func,
    "onEmptied": _propTypes.default.func,
    "onEmptiedCapture": _propTypes.default.func,
    "onEncrypted": _propTypes.default.func,
    "onEncryptedCapture": _propTypes.default.func,
    "onEnded": _propTypes.default.func,
    "onEndedCapture": _propTypes.default.func,
    "onError": _propTypes.default.func,
    "onErrorCapture": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "onFocusCapture": _propTypes.default.func,
    "onGotPointerCapture": _propTypes.default.func,
    "onGotPointerCaptureCapture": _propTypes.default.func,
    "onInput": _propTypes.default.func,
    "onInputCapture": _propTypes.default.func,
    "onInvalid": _propTypes.default.func,
    "onInvalidCapture": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onKeyDownCapture": _propTypes.default.func,
    "onKeyPress": _propTypes.default.func,
    "onKeyPressCapture": _propTypes.default.func,
    "onKeyUp": _propTypes.default.func,
    "onKeyUpCapture": _propTypes.default.func,
    "onLoad": _propTypes.default.func,
    "onLoadCapture": _propTypes.default.func,
    "onLoadedData": _propTypes.default.func,
    "onLoadedDataCapture": _propTypes.default.func,
    "onLoadedMetadata": _propTypes.default.func,
    "onLoadedMetadataCapture": _propTypes.default.func,
    "onLoadStart": _propTypes.default.func,
    "onLoadStartCapture": _propTypes.default.func,
    "onLostPointerCapture": _propTypes.default.func,
    "onLostPointerCaptureCapture": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "onMouseDownCapture": _propTypes.default.func,
    "onMouseEnter": _propTypes.default.func,
    "onMouseLeave": _propTypes.default.func,
    "onMouseMove": _propTypes.default.func,
    "onMouseMoveCapture": _propTypes.default.func,
    "onMouseOut": _propTypes.default.func,
    "onMouseOutCapture": _propTypes.default.func,
    "onMouseOver": _propTypes.default.func,
    "onMouseOverCapture": _propTypes.default.func,
    "onMouseUp": _propTypes.default.func,
    "onMouseUpCapture": _propTypes.default.func,
    "onPaste": _propTypes.default.func,
    "onPasteCapture": _propTypes.default.func,
    "onPause": _propTypes.default.func,
    "onPauseCapture": _propTypes.default.func,
    "onPlay": _propTypes.default.func,
    "onPlayCapture": _propTypes.default.func,
    "onPlaying": _propTypes.default.func,
    "onPlayingCapture": _propTypes.default.func,
    "onPointerCancel": _propTypes.default.func,
    "onPointerCancelCapture": _propTypes.default.func,
    "onPointerDown": _propTypes.default.func,
    "onPointerDownCapture": _propTypes.default.func,
    "onPointerEnter": _propTypes.default.func,
    "onPointerEnterCapture": _propTypes.default.func,
    "onPointerLeave": _propTypes.default.func,
    "onPointerLeaveCapture": _propTypes.default.func,
    "onPointerMove": _propTypes.default.func,
    "onPointerMoveCapture": _propTypes.default.func,
    "onPointerOut": _propTypes.default.func,
    "onPointerOutCapture": _propTypes.default.func,
    "onPointerOver": _propTypes.default.func,
    "onPointerOverCapture": _propTypes.default.func,
    "onPointerUp": _propTypes.default.func,
    "onPointerUpCapture": _propTypes.default.func,
    "onProgress": _propTypes.default.func,
    "onProgressCapture": _propTypes.default.func,
    "onRateChange": _propTypes.default.func,
    "onRateChangeCapture": _propTypes.default.func,
    "onReset": _propTypes.default.func,
    "onResetCapture": _propTypes.default.func,
    "onScroll": _propTypes.default.func,
    "onScrollCapture": _propTypes.default.func,
    "onSeeked": _propTypes.default.func,
    "onSeekedCapture": _propTypes.default.func,
    "onSeeking": _propTypes.default.func,
    "onSeekingCapture": _propTypes.default.func,
    "onSelect": _propTypes.default.func,
    "onSelectCapture": _propTypes.default.func,
    "onStalled": _propTypes.default.func,
    "onStalledCapture": _propTypes.default.func,
    "onSubmit": _propTypes.default.func,
    "onSubmitCapture": _propTypes.default.func,
    "onSuspend": _propTypes.default.func,
    "onSuspendCapture": _propTypes.default.func,
    "onTimeUpdate": _propTypes.default.func,
    "onTimeUpdateCapture": _propTypes.default.func,
    "onTouchCancel": _propTypes.default.func,
    "onTouchCancelCapture": _propTypes.default.func,
    "onTouchEnd": _propTypes.default.func,
    "onTouchEndCapture": _propTypes.default.func,
    "onTouchMove": _propTypes.default.func,
    "onTouchMoveCapture": _propTypes.default.func,
    "onTouchStart": _propTypes.default.func,
    "onTouchStartCapture": _propTypes.default.func,
    "onTransitionEnd": _propTypes.default.func,
    "onTransitionEndCapture": _propTypes.default.func,
    "onVolumeChange": _propTypes.default.func,
    "onVolumeChangeCapture": _propTypes.default.func,
    "onWaiting": _propTypes.default.func,
    "onWaitingCapture": _propTypes.default.func,
    "onWheel": _propTypes.default.func,
    "onWheelCapture": _propTypes.default.func,
    "pattern": _propTypes.default.string,
    "placeholder": _propTypes.default.string,
    "prefix": _propTypes.default.string,
    "property": _propTypes.default.string,
    "radioGroup": _propTypes.default.string,
    "readOnly": _propTypes.default.bool,
    "rel": _propTypes.default.string,
    "required": _propTypes.default.bool,
    "resource": _propTypes.default.string,
    "results": _propTypes.default.number,
    "rev": _propTypes.default.string,
    "role": _propTypes.default.string,
    "security": _propTypes.default.string,
    "slot": _propTypes.default.string,
    "spellCheck": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "src": _propTypes.default.string,
    "step": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "style": _propTypes.default.object,
    "suppressContentEditableWarning": _propTypes.default.bool,
    "suppressHydrationWarning": _propTypes.default.bool,
    "tabIndex": _propTypes.default.number,
    "title": _propTypes.default.string,
    "translate": _propTypes.default.oneOf(["no", "yes"]),
    "type": _propTypes.default.string.isRequired,
    "typeof": _propTypes.default.string,
    "unselectable": _propTypes.default.oneOf(["off", "on"]),
    "validationIconId": _propTypes.default.string,
    "value": _propTypes.default.string,
    "vocab": _propTypes.default.string,
    "width": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  };
}
HiddenCheckableInput.displayName = "HiddenCheckableInput";
var _default = exports.default = /*#__PURE__*/_react.default.memo(HiddenCheckableInput);