import React from "react";
export interface CommonHiddenCheckableInputProps extends Omit<React.InputHTMLAttributes<HTMLInputElement>, "value" | "size" | "type"> {
    /** The id of the element that describe the input. */
    ariaDescribedBy?: string;
    /** Prop to specify the aria-labelledby attribute of the input */
    ariaLabelledBy?: string;
    /** If true the Component will be focused when page load */
    autoFocus?: boolean;
    /** Checked state of the input */
    checked?: boolean;
    /** Input name */
    name?: string;
    /** OnChange event handler */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** OnFocus event handler */
    onFocus?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Blur event handler */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** OnMouseLeave event handler */
    onMouseLeave?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** OnMouseEnter event handler */
    onMouseEnter?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** Id of the validation icon */
    validationIconId?: string;
    /** Value of the input */
    value?: string;
}
export interface HiddenCheckableInputProps extends CommonHiddenCheckableInputProps {
    /** HTML type attribute of the input */
    type: string;
    /** Role attribute of the input */
    role?: string;
}
declare const _default: React.MemoExoticComponent<React.ForwardRefExoticComponent<HiddenCheckableInputProps & React.RefAttributes<HTMLInputElement>>>;
export default _default;
