"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledCheckableInputWrapper = exports.StyledCheckableInput = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _fieldHelp = _interopRequireDefault(require("../field-help/field-help.style"));
var _formField = require("../form-field/form-field.style");
var _hiddenCheckableInput = _interopRequireDefault(require("./hidden-checkable-input.style"));
var _label = _interopRequireWildcard(require("../label/label.style"));
var _help = _interopRequireDefault(require("../../components/help/help.style"));
var _validationIcon = _interopRequireDefault(require("../validations/validation-icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledCheckableInput = exports.StyledCheckableInput = _styledComponents.default.div`
  display: inline-block;
  position: relative;
`;
const StyledCheckableInputWrapper = exports.StyledCheckableInputWrapper = _styledComponents.default.div`
  ${({
  disabled,
  fieldHelpInline,
  inputWidth,
  labelWidth,
  labelInline,
  reverse
}) => (0, _styledComponents.css)`
    ${_formField.FieldLineStyle} {
      display: flex;
    }

    ${_label.StyledLabelContainer} {
      ${labelInline && (0, _styledComponents.css)`
        justify-content: ${reverse ? "flex-start" : "flex-end"};
      `}
      padding-top: 0;
      width: auto;

      & ${_help.default}, & ${_validationIcon.default} {
        color: var(--colorsUtilityYin065);
        vertical-align: middle;

        &:hover,
        &:focus {
          color: var(--colorsUtilityYin090);
        }
      }
    }

    ${_fieldHelp.default} {
      flex-basis: 100%;
    }

    ${disabled && (0, _styledComponents.css)`
      ${_hiddenCheckableInput.default},
      ${_label.default} {
        &:hover,
        &:focus {
          outline: none;
          cursor: not-allowed;
        }
      }
    `}

    ${fieldHelpInline && (0, _styledComponents.css)`
      ${_formField.FieldLineStyle} {
        flex-wrap: nowrap;
      }

      ${StyledCheckableInput} {
        margin-right: 0;
        margin-left: 8px;
      }

      ${_fieldHelp.default} {
        flex-grow: 0;
        flex-basis: auto;
        padding-left: 0;
        width: auto;
      }
    `}

    ${reverse && fieldHelpInline && (0, _styledComponents.css)`
      ${StyledCheckableInput} {
        margin-left: 0;
      }

      ${_fieldHelp.default} {
        flex-grow: 1;
      }
    `}

    ${inputWidth !== undefined && inputWidth !== 0 && (0, _styledComponents.css)`
      ${StyledCheckableInput} {
        width: ${inputWidth}% !important;
      }
    `}

    ${labelWidth !== undefined && labelWidth !== 0 && `
      ${_label.StyledLabelContainer} {
        width: ${labelWidth}% !important;
      }
    `}
  `}
`;