"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _characterCount = require("./character-count.style");
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const CharacterCount = ({
  value,
  debouncedValue = value,
  limit,
  isDebouncedOverLimit,
  isOverLimit,
  visuallyHiddenHintId
}) => {
  const limitMinusValue = +limit - +value;
  const valueMinusLimit = +value - +limit;
  const debouncedLimitMinusValue = +limit - +debouncedValue;
  const debouncedValueMinusLimit = debouncedValue - +limit;
  const l = (0, _useLocale.default)();
  const getFormatNumber = (rawValue, locale) => new Intl.NumberFormat(locale).format(rawValue);
  return /*#__PURE__*/_react.default.createElement(_characterCount.StyledCharacterCountWrapper, null, /*#__PURE__*/_react.default.createElement(_characterCount.VisuallyHiddenHint, {
    "data-element": "visually-hidden-hint",
    id: visuallyHiddenHintId
  }, l.characterCount.visuallyHiddenHint(getFormatNumber(limit, l.locale()))), /*#__PURE__*/_react.default.createElement(_characterCount.StyledCharacterCount, {
    "aria-hidden": "true",
    isOverLimit: isOverLimit,
    "data-element": "character-count"
  }, !isOverLimit ? l.characterCount.charactersLeft(limitMinusValue, getFormatNumber(limitMinusValue, l.locale())) : l.characterCount.tooManyCharacters(valueMinusLimit, getFormatNumber(valueMinusLimit, l.locale()))), /*#__PURE__*/_react.default.createElement(_characterCount.VisuallyHiddenCharacterCount, {
    "data-element": "visually-hidden-character-count",
    "aria-live": "polite"
  }, !isDebouncedOverLimit ? l.characterCount.charactersLeft(debouncedLimitMinusValue, getFormatNumber(debouncedLimitMinusValue, l.locale())) : l.characterCount.tooManyCharacters(debouncedValueMinusLimit, getFormatNumber(debouncedValueMinusLimit, l.locale()))));
};
var _default = exports.default = CharacterCount;