import { useMemo, useEffect, useRef } from "react";
import throttle from "lodash/throttle";

// eslint-disable-next-line @typescript-eslint/no-explicit-any

const useThrottle = (callback, delay) => {
  const callbackRef = useRef(callback);
  useEffect(() => {
    callbackRef.current = callback;
  });
  const throttledCallback = useMemo(() => throttle(callbackRef.current, delay), [delay]);
  useEffect(() => {
    return () => {
      throttledCallback.cancel();
    };
  });
  return throttledCallback;
};
export default useThrottle;