import { useRef, useLayoutEffect } from "react";
export default function useResizeObserver( /** Reference to the resizable HTML element */
ref, /** Callback meant to be executed on element resize */
onResize, /** Flag to indicate whether hook should be disabled  */
disabled) {
  const observer = useRef();
  const onResizeRef = useRef(onResize);
  onResizeRef.current = onResize;
  useLayoutEffect(() => {
    const referenceRef = ref.current;
    if (!disabled && referenceRef) {
      observer.current = new ResizeObserver(() => {
        onResizeRef?.current();
      });
      observer.current.observe(referenceRef);
    }
    return () => {
      if (!disabled && referenceRef && observer.current) {
        observer.current.unobserve(referenceRef);
        observer.current.disconnect();
      }
    };
  }, [ref, disabled]);
}