import { useRef, useLayoutEffect } from "react";
import { computePosition, autoUpdate } from "@floating-ui/dom";
const useFloating = ({
  isOpen,
  reference,
  floating,
  strategy = "absolute",
  placement,
  middleware,
  animationFrame
}) => {
  const originalValues = useRef(null);
  useLayoutEffect(() => {
    let cleanup;
    const referenceElement = reference.current;
    const floatingElement = floating.current;
    if (referenceElement && floatingElement && isOpen) {
      const {
        left,
        top,
        position,
        width,
        height
      } = floatingElement.style;
      originalValues.current = {
        left,
        top,
        position,
        width,
        height
      };
      Object.assign(floatingElement.style, {
        position: strategy,
        top: 0,
        left: 0
      });
      const update = () => {
        computePosition(referenceElement, floatingElement, {
          strategy,
          middleware,
          placement
        }).then(({
          x,
          y,
          placement: currentPlacement
        }) => {
          Object.assign(floatingElement.style, {
            left: `${x}px`,
            top: `${y}px`,
            position: strategy
          });
          floatingElement.setAttribute("data-floating-placement", currentPlacement);
        });
      };
      cleanup = autoUpdate(referenceElement, floatingElement, update, {
        animationFrame
      });
    }
    return () => {
      if (cleanup && floatingElement) {
        cleanup();
        cleanup = null;
        Object.assign(floatingElement.style, originalValues.current);
        floatingElement.removeAttribute("data-floating-placement");
      }
    };
  }, [isOpen, reference, floating, strategy, middleware, placement, animationFrame]);
};
export default useFloating;