/// <reference types="react" />
import { Strategy, Middleware, Placement } from "@floating-ui/dom";
declare type CustomRefObject<T> = {
    current?: T | null;
};
export interface UseFloatingProps {
    isOpen?: boolean;
    reference: CustomRefObject<HTMLElement | null>;
    floating: React.RefObject<HTMLElement | null>;
    strategy?: Strategy;
    middleware?: Middleware[];
    placement?: Placement;
    animationFrame?: boolean;
}
declare const useFloating: ({ isOpen, reference, floating, strategy, placement, middleware, animationFrame, }: UseFloatingProps) => void;
export default useFloating;
