import { useMemo, useEffect, useRef } from "react";
import debounce from "lodash/debounce";

// eslint-disable-next-line @typescript-eslint/no-explicit-any

const useDebounce = (callback, delay) => {
  const callbackRef = useRef(callback);
  useEffect(() => {
    callbackRef.current = callback;
  });
  const debouncedCallback = useMemo(() => debounce(callbackRef.current, delay), [delay]);
  useEffect(() => {
    return () => {
      debouncedCallback.cancel();
    };
  });
  return debouncedCallback;
};
export default useDebounce;