import { useState, useRef, useEffect, useCallback } from "react";
import Events from "../../../__internal__/utils/helpers/events";
import useMenuKeyboardNavigation from "../useMenuKeyboardNavigation";
const useChildButtons = (toggleButtonRef, widthRatio = 1) => {
  const [showAdditionalButtons, setShowAdditionalButtons] = useState(false);
  const [minWidth, setMinWidth] = useState(0);
  const buttonNode = useRef(null);
  const childrenContainer = useRef(null);
  const focusFirstChildButtonOnOpen = useRef(false);
  const hideButtons = useCallback(() => {
    setShowAdditionalButtons(false);
  }, []);
  function showButtons() {
    setShowAdditionalButtons(true);

    /* istanbul ignore else */
    if (buttonNode.current) {
      setMinWidth(widthRatio * buttonNode.current.getBoundingClientRect().width);
    }
  }
  const getButtonChildren = useCallback(() => childrenContainer.current?.querySelectorAll('[data-component="button"]'), []);
  useEffect(() => {
    const firstChild = getButtonChildren()?.[0];
    if (focusFirstChildButtonOnOpen.current && showAdditionalButtons && firstChild) {
      focusFirstChildButtonOnOpen.current = false;
      firstChild.focus();
    }
  }, [showAdditionalButtons, getButtonChildren]);
  const handleToggleButtonKeyDown = ev => {
    if (Events.isEnterKey(ev) || Events.isSpaceKey(ev) || Events.isDownKey(ev) || Events.isUpKey(ev)) {
      ev.preventDefault();
      if (!showAdditionalButtons) {
        showButtons();
      }
      focusFirstChildButtonOnOpen.current = true;
    }
  };
  const handleKeyDown = useMenuKeyboardNavigation(toggleButtonRef, getButtonChildren, hideButtons, showAdditionalButtons);
  const onChildButtonClick = childOnClick => ev => {
    childOnClick?.(ev);
    hideButtons();
    toggleButtonRef.current?.focus();
  };
  const wrapperProps = {
    "data-element": "additional-buttons",
    role: "list",
    onKeyDown: handleKeyDown,
    minWidth,
    ref: childrenContainer
  };
  const contextValue = {
    inSplitButton: true,
    onChildButtonClick
  };
  return {
    showAdditionalButtons,
    showButtons,
    hideButtons,
    buttonNode,
    handleToggleButtonKeyDown,
    wrapperProps,
    contextValue
  };
};
export default useChildButtons;