function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags";
import { StyledVerticalMenu, StyledList } from "./vertical-menu.style";
export const VerticalMenu = ({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  width = "322px",
  children,
  height = "100%",
  ...rest
}) => {
  return /*#__PURE__*/React.createElement(StyledVerticalMenu, _extends({
    boxSizing: "border-box",
    scrollVariant: "light",
    backgroundColor: "var(--colorsComponentsLeftnavWinterStandardBackground)",
    width: width,
    height: height,
    py: 1,
    as: "nav",
    overflow: "auto",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy
  }, tagComponent("vertical-menu", rest)), /*#__PURE__*/React.createElement(StyledList, null, children));
};
export default VerticalMenu;