function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags";
import { filterStyledSystemPaddingProps } from "../../../style/utils";
import { StyledVerticalMenuItem, StyledTitle } from "../vertical-menu.style";
export const VerticalMenuTrigger = ({
  height = "40px",
  p = 2,
  onClick,
  children,
  ...rest
}) => {
  const paddingProps = filterStyledSystemPaddingProps(rest);
  return /*#__PURE__*/React.createElement(StyledVerticalMenuItem, _extends({
    onClick: onClick,
    as: "button",
    height: height,
    p: p,
    tabIndex: 0
  }, paddingProps, tagComponent("vertical-menu-trigger", rest)), /*#__PURE__*/React.createElement(StyledTitle, null, children));
};
export default VerticalMenuTrigger;