function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useContext } from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags";
import { filterStyledSystemPaddingProps } from "../../../style/utils";
import VerticalMenuFullScreenContext from "../vertical-menu-full-screen/vertical-menu-full-screen.context";
import { StyledVerticalMenuItem, StyledTitle, StyledAdornment, StyledList, StyledChevronIcon, StyledTitleIcon } from "../vertical-menu.style";
const MenuItemContext = /*#__PURE__*/React.createContext({
  level: 0
});
export const VerticalMenuItem = ({
  defaultOpen = false,
  title,
  iconType,
  adornment,
  children,
  component,
  active,
  height = "56px",
  href,
  ...rest
}) => {
  const [isOpen, setIsOpen] = useState(defaultOpen);
  const handleOnClick = () => {
    setIsOpen(state => !state);
  };
  const {
    level
  } = useContext(MenuItemContext);
  const {
    isFullScreen
  } = useContext(VerticalMenuFullScreenContext);
  const renderAdornment = () => typeof adornment === "function" ? adornment(isOpen) : adornment;
  const shouldDisplayActiveState = typeof active === "function" ? active(isOpen) : active;
  let itemProps = {};
  if (href) {
    itemProps = {
      as: "a",
      href
    };
  }
  if (component) {
    itemProps = {
      as: component,
      href,
      tabIndex: 0,
      ...rest
    };
  }
  if (children) {
    itemProps = {
      as: "button",
      type: "button",
      "aria-expanded": isOpen,
      onClick: handleOnClick
    };
  }
  const paddingX = `calc(var(--spacing500) + (${level} * var(--spacing400)))`;
  return /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(StyledVerticalMenuItem, _extends({
    height: height,
    px: paddingX,
    py: 2,
    active: shouldDisplayActiveState
  }, itemProps, filterStyledSystemPaddingProps(rest), tagComponent("vertical-menu-item", rest)), iconType && /*#__PURE__*/React.createElement(StyledTitleIcon, {
    type: iconType
  }), /*#__PURE__*/React.createElement(StyledTitle, null, title), adornment && /*#__PURE__*/React.createElement(StyledAdornment, null, renderAdornment()), children && !isFullScreen && /*#__PURE__*/React.createElement(StyledChevronIcon, {
    type: isOpen ? "chevron_up_thick" : "chevron_down_thick"
  })), (isOpen || isFullScreen) && /*#__PURE__*/React.createElement(MenuItemContext.Provider, {
    value: {
      level: level + 1
    }
  }, /*#__PURE__*/React.createElement(StyledList, null, children)));
};
export default VerticalMenuItem;