import React from "react";
import { PaddingProps } from "styled-system";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
import { IconType } from "../../icon";
export interface VerticalMenuItemProps<T = React.ElementType> extends PaddingProps, TagProps {
    /** Children of the menu item - another level of VerticalMenuItems */
    children?: React.ReactNode;
    /** Default open state of the component */
    defaultOpen?: boolean;
    /** Title of the menu item */
    title: string;
    /** Adornment of the menu item meant to be rendered on the right side */
    adornment?: React.ReactNode | ((isOpen: boolean) => React.ReactNode);
    /** Icon meant to be rendered on the left side */
    iconType?: IconType;
    /** Whether the menu item is active or not */
    active?: boolean | ((isOpen: boolean) => boolean);
    /** Height of the menu item */
    height?: string;
    /**  Href, when passed the menu item will be rendered as an anchor tag */
    href?: string;
    /** Optional component to render instead of the default div, useful for rendering router link components */
    component?: T;
}
declare type InferredComponentProps<T extends React.ElementType> = Omit<React.ComponentProps<T>, keyof VerticalMenuItemProps<T>>;
export declare const VerticalMenuItem: <T>({ defaultOpen, title, iconType, adornment, children, component, active, height, href, ...rest }: T extends React.ElementType<any> ? InferredComponentProps<T> & VerticalMenuItemProps<T> : VerticalMenuItemProps<React.ElementType<any>>) => React.JSX.Element;
export default VerticalMenuItem;
