function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useRef } from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags";
import useLocale from "../../../hooks/__internal__/useLocale";
import Portal from "../../portal";
import FocusTrap from "../../../__internal__/focus-trap/focus-trap.component";
import IconButton from "../../icon-button";
import Icon from "../../icon";
import Box from "../../box";
import { StyledList, StyledVerticalMenuFullScreen } from "../vertical-menu.style";
import VerticalMenuFullScreenContext from "../vertical-menu-full-screen/vertical-menu-full-screen.context";
import Events from "../../../__internal__/utils/helpers/events/events";
export const VerticalMenuFullScreen = ({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  children,
  isOpen,
  onClose,
  ...rest
}) => {
  const l = useLocale();
  const menuWrapperRef = useRef(null);
  const handleKeyDown = useCallback(ev => {
    // istanbul ignore else
    if (Events.isEscKey(ev)) {
      onClose(ev);
    }
  }, [onClose]);

  // TODO remove this as part of FE-5650
  if (!isOpen) return null;
  return /*#__PURE__*/React.createElement(Portal, null, /*#__PURE__*/React.createElement(FocusTrap, {
    isOpen: isOpen,
    wrapperRef: menuWrapperRef
  }, /*#__PURE__*/React.createElement(StyledVerticalMenuFullScreen, _extends({
    ref: menuWrapperRef,
    scrollVariant: "light",
    as: "nav",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    onKeyDown: handleKeyDown
  }, tagComponent("vertical-menu-full-screen", rest)), /*#__PURE__*/React.createElement(Box, {
    display: "flex",
    justifyContent: "flex-end",
    height: "60px",
    alignItems: "flex-start",
    px: "20px",
    pt: "20px",
    boxSizing: "border-box"
  }, /*#__PURE__*/React.createElement(IconButton, {
    "aria-label": l.verticalMenuFullScreen.ariaLabels.close(),
    onClick: onClose,
    "data-element": "close"
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "close",
    color: "var(--colorsComponentsLeftnavWinterStandardContent)",
    bgSize: "small",
    fontSize: "medium"
  }))), /*#__PURE__*/React.createElement(VerticalMenuFullScreenContext.Provider, {
    value: {
      isFullScreen: true
    }
  }, /*#__PURE__*/React.createElement(StyledList, null, children)))));
};
export default VerticalMenuFullScreen;