import React from "react";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
export interface VerticalMenuFullScreenProps extends TagProps {
    /** An aria-label attribute for the menu */
    "aria-label"?: string;
    /** An aria-labelledby attribute for the menu */
    "aria-labelledby"?: string;
    /**  Content of the menu - VerticalMenuItem */
    children: React.ReactNode;
    /** Whether the menu is open or not */
    isOpen: boolean;
    /** A callback to be called when the close icon is clicked or enter is pressed when focused */
    onClose: (ev: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
}
export declare const VerticalMenuFullScreen: ({ "aria-label": ariaLabel, "aria-labelledby": ariaLabelledBy, children, isOpen, onClose, ...rest }: VerticalMenuFullScreenProps) => React.JSX.Element | null;
export default VerticalMenuFullScreen;
