function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags";
import { filterStyledSystemMarginProps, filterStyledSystemPaddingProps } from "../../style/utils";
import StyledTypography from "./typography.style";
export const VARIANT_TYPES = ["h1-large", "h1", "h2", "h3", "h4", "h5", "segment-header", "segment-header-small", "segment-subheader", "segment-subheader-alt", "p", "span", "small", "big", "sup", "sub", "strong", "b", "em", "ul", "ol"];
export const Typography = ({
  "data-component": dataComponent,
  variant = "p",
  as,
  id,
  fontSize,
  fontWeight,
  textTransform,
  lineHeight,
  textDecoration,
  display,
  listStyleType,
  whiteSpace,
  wordWrap,
  textAlign,
  textOverflow,
  truncate,
  color = "blackOpacity90",
  backgroundColor,
  bg,
  opacity,
  children,
  className,
  screenReaderOnly,
  isDisabled,
  "aria-hidden": ariaHidden,
  ...rest
}) => {
  return /*#__PURE__*/React.createElement(StyledTypography, _extends({
    variant: variant,
    as: as,
    id: id,
    fontSize: fontSize,
    fontWeight: fontWeight,
    textTransform: textTransform,
    lineHeight: lineHeight,
    textDecoration: textDecoration,
    display: display,
    listStyleType: listStyleType,
    whiteSpace: whiteSpace,
    wordWrap: wordWrap,
    textAlign: textAlign,
    textOverflow: textOverflow,
    truncate: truncate,
    color: color,
    backgroundColor: backgroundColor,
    bg: bg,
    opacity: opacity,
    className: className,
    screenReaderOnly: screenReaderOnly,
    isDisabled: isDisabled,
    "aria-hidden": ariaHidden
  }, tagComponent(dataComponent, rest), filterStyledSystemMarginProps(rest), filterStyledSystemPaddingProps(rest)), children);
};
Typography.displayName = "Typography";
export default Typography;