function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useMemo, useCallback, useState, useEffect } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { offset, flip, shift, arrow, limitShift, autoUpdate, useFloating } from "@floating-ui/react-dom";
import StyledTooltip from "./tooltip.style";
import StyledPointer from "./tooltip-pointer.style";
import { TOOLTIP_POSITIONS } from "./tooltip.config";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import Portal from "../portal";
function preserveRef(ref, node) {
  if (!ref) return;
  if (typeof ref === "function") {
    ref(node);
  }
  if (typeof ref === "object" && "current" in ref) {
    ref.current = node;
  }
}
const TOOLTIP_DELAY = 100;
const Tooltip = /*#__PURE__*/React.forwardRef(({
  children,
  isVisible,
  position = "top",
  message,
  type,
  size = "medium",
  isPartOfInput,
  inputSize = "medium",
  id,
  bgColor,
  fontColor,
  flipOverrides,
  target,
  ...rest
}, ref) => {
  const targetInternalRef = useRef(null);
  const isControlled = isVisible !== undefined;
  const [isOpen, setIsOpen] = useState(false);
  let showTooltip = isOpen;
  if (isControlled) {
    showTooltip = isVisible;
  }
  const showDelayedTimeout = useRef(undefined);
  const hideDelayedTimeout = useRef(undefined);
  useEffect(() => {
    return () => {
      clearTimeout(showDelayedTimeout.current);
      clearTimeout(hideDelayedTimeout.current);
    };
  }, []);
  const show = useCallback(() => setIsOpen(true), []);
  const hide = useCallback(() => setIsOpen(false), []);
  const showDelayed = useCallback(() => {
    showDelayedTimeout.current = window.setTimeout(show, TOOLTIP_DELAY);
  }, [show]);
  const hideDelayed = useCallback(() => {
    hideDelayedTimeout.current = window.setTimeout(hide, TOOLTIP_DELAY);
  }, [hide]);
  useEffect(() => {
    const events = {
      mouseenter: showDelayed,
      mouseleave: hideDelayed,
      focus: show,
      blur: hide
    };
    const targetElement = target || targetInternalRef.current;
    if (!isControlled) {
      Object.entries(events).forEach(([event, handler]) => {
        targetElement?.addEventListener(event, handler);
      });
    }
    return () => {
      if (!isControlled) {
        Object.entries(events).forEach(([event, handler]) => {
          targetElement?.removeEventListener(event, handler);
        });
      }
    };
  }, [children, show, showDelayed, hide, hideDelayed, isControlled, target]);
  const flipOverridesRef = useRef(flipOverrides);
  flipOverridesRef.current = flipOverrides;
  const arrowReference = useRef(null);
  const calculateOffset = useCallback(placement => {
    let mainAxisOffset = 9;
    if (isPartOfInput) {
      const offsets = {
        small: 5,
        medium: ["top", "bottom"].includes(placement) ? 6 : 8,
        large: ["top", "bottom"].includes(placement) ? 10 : 12
      };
      mainAxisOffset = offsets[inputSize];
    }
    return mainAxisOffset;
  }, [inputSize, isPartOfInput]);
  const defaultMiddleware = useMemo(() => [offset(({
    placement
  }) => ({
    mainAxis: calculateOffset(placement)
  })), flip({
    fallbackPlacements: flipOverridesRef.current
  }), shift({
    padding: 5,
    limiter: limitShift({
      offset: ({
        rects
      }) => ({
        mainAxis: rects.reference.height
      })
    })
  }), arrow({
    element: arrowReference
  })], [calculateOffset, arrowReference]);
  const {
    x,
    y,
    reference,
    floating,
    strategy,
    placement: currentPlacement,
    middlewareData
  } = useFloating({
    placement: position,
    middleware: defaultMiddleware,
    whileElementsMounted: autoUpdate
  });
  const tooltipStyle = {
    position: strategy,
    top: y ?? 0,
    left: x ?? 0
  };
  const handleTargetRef = useCallback(node => {
    reference(target || node);
    targetInternalRef.current = node;
    preserveRef(
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    children.ref, node);
  }, [reference, children, target]);
  const handleFloatingRef = useCallback(node => {
    floating(node);
    preserveRef(ref, node);
  }, [floating, ref]);
  const staticSide = {
    top: "bottom",
    right: "left",
    bottom: "top",
    left: "right"
  }[currentPlacement.split("-")[0]];
  const {
    x: arrowX,
    y: arrowY
  } = middlewareData.arrow || {};
  const arrowStyle = {
    left: arrowX,
    top: arrowY,
    [staticSide]: "-6px"
  };
  const isFlipOverridesValid = !flipOverrides || Array.isArray(flipOverrides) && flipOverrides.every(placement => TOOLTIP_POSITIONS.includes(placement));
  !isFlipOverridesValid ? process.env.NODE_ENV !== "production" ? invariant(false, `The flipOverrides prop supplied to Tooltip must be an array containing some or all of ["top", "bottom", "left", "right"].`) : invariant(false) : void 0;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.cloneElement(children, {
    ref: handleTargetRef
  }), showTooltip ? /*#__PURE__*/React.createElement(Portal, null, /*#__PURE__*/React.createElement(StyledTooltip, _extends({
    "data-element": "tooltip",
    role: "tooltip",
    tabIndex: -1,
    type: type,
    size: size,
    id: id
  }, tagComponent("tooltip", rest), {
    ref: handleFloatingRef,
    bgColor: bgColor,
    fontColor: fontColor,
    style: tooltipStyle,
    "data-placement": currentPlacement
  }), /*#__PURE__*/React.createElement(StyledPointer, {
    type: type,
    ref: arrowReference,
    "data-element": "tooltip-pointer",
    bgColor: bgColor,
    style: arrowStyle
  }), message)) : null);
});
if (process.env.NODE_ENV !== "production") {
  Tooltip.propTypes = {
    "bgColor": PropTypes.string,
    "children": PropTypes.element.isRequired,
    "flipOverrides": PropTypes.arrayOf(PropTypes.oneOf(["bottom", "left", "right", "top"])),
    "fontColor": PropTypes.string,
    "id": PropTypes.string,
    "inputSize": PropTypes.oneOf(["large", "medium", "small"]),
    "isPartOfInput": PropTypes.bool,
    "isVisible": PropTypes.bool,
    "message": PropTypes.node,
    "position": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "size": PropTypes.oneOf(["large", "medium"]),
    "target": function (props, propName) {
      if (props[propName] == null) {
        return null;
      } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
        return new Error("Expected prop '" + propName + "' to be of type Element");
      }
    },
    "type": PropTypes.string
  };
}
export { Tooltip };
Tooltip.displayName = "Tooltip";
export default Tooltip;