import React from "react";
import { TooltipPositions } from "./tooltip.config";
export declare type InputSizes = "small" | "medium" | "large";
export interface TooltipProps {
    /** The message to be displayed within the tooltip */
    message: React.ReactNode;
    /** The id attribute to use for the tooltip */
    id?: string;
    /** Whether to to show the Tooltip */
    isVisible?: boolean;
    /** Sets position of the tooltip */
    position?: TooltipPositions;
    /** Defines the message type */
    type?: string;
    /** Children elements */
    children: React.ReactElement;
    /** Defines the size of the tooltip content */
    size?: "medium" | "large";
    /** Override background color of the Tooltip, provide any color from palette or any valid css color value. */
    bgColor?: string;
    /** Override font color of the Tooltip, provide any color from palette or any valid css color value. */
    fontColor?: string;
    /**
     * Overrides the default flip behaviour of the Tooltip,
     * must be an array containing some or all of ["top", "bottom", "left", "right"]
     * (see https://popper.js.org/docs/v2/modifiers/flip/#fallbackplacements)
     */
    flipOverrides?: TooltipPositions[];
    /** @ignore @private */
    target?: HTMLElement;
    /** @ignore @private */
    isPartOfInput?: boolean;
    /** @ignore @private */
    inputSize?: InputSizes;
}
export declare const Tooltip: React.ForwardRefExoticComponent<TooltipProps & React.RefAttributes<HTMLDivElement | null>>;
export default Tooltip;
