function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useRef, useState } from "react";
import PropTypes from "prop-types";
import { TransitionGroup, CSSTransition } from "react-transition-group";
import Icon from "../icon";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { StyledToast, TypeIcon, StyledToastContent, ToastWrapper, StyledPortal } from "./toast.style";
import IconButton from "../icon-button";
import Events from "../../__internal__/utils/helpers/events";
import useLocale from "../../hooks/__internal__/useLocale";
import useModalManager from "../../hooks/__internal__/useModalManager";
import Logger from "../../__internal__/utils/logger";
let isDeprecationWarningTriggered = false;
const Toast = /*#__PURE__*/React.forwardRef(({
  align,
  alignY,
  children,
  className,
  id,
  isCenter = true,
  maxWidth,
  onDismiss,
  open = true,
  targetPortalId,
  timeout,
  variant = "success",
  disableAutoFocus,
  closeButtonDataProps,
  ...restProps
}, ref) => {
  const isNotice = variant === "notice";
  const isNotification = variant === "notification";
  const locale = useLocale();
  const toastRef = useRef(null);
  const timer = useRef(null);
  const toastContentNodeRef = useRef(null);
  const closeIconRef = useRef(null);
  const focusedElementBeforeOpening = useRef(null);
  const [tabIndex, setTabIndex] = useState(0);
  let refToPass = toastRef;
  if (ref && typeof ref === "object" && "current" in ref) {
    refToPass = ref;
  }
  if (isCenter !== undefined && !isDeprecationWarningTriggered) {
    isDeprecationWarningTriggered = true;
    Logger.deprecate(`isCenter prop in ${Toast.displayName} is being deprecated in favour of the align prop.`);
  }
  const dismissToast = useCallback(ev => {
    if (onDismiss && Events.isEscKey(ev)) {
      ev.stopImmediatePropagation();
      onDismiss(ev);
    }
  }, [onDismiss]);
  useModalManager({
    open,
    closeModal: dismissToast,
    modalRef: refToPass,
    topModalOverride: true
  });
  useEffect(() => {
    /* istanbul ignore next */
    if (timer.current) clearTimeout(timer.current);
    if (!timeout || !open || !onDismiss) {
      return;
    }
    timer.current = setTimeout(() => onDismiss(), +timeout);
  }, [onDismiss, open, timeout]);
  useEffect(() => {
    if (!disableAutoFocus) {
      if (open) {
        // setTimeout needed as otherwise this runs before the ref is populated
        setTimeout(() => {
          focusedElementBeforeOpening.current = document.activeElement;
          toastContentNodeRef.current?.focus();
        }, 0);
      } else if (focusedElementBeforeOpening.current) {
        focusedElementBeforeOpening.current.focus();
        focusedElementBeforeOpening.current = null;
        setTabIndex(0);
      }
    }
  }, [open, onDismiss, disableAutoFocus]);
  useEffect(() => {
    return () => {
      if (focusedElementBeforeOpening.current) {
        focusedElementBeforeOpening.current.focus();
      }
    };
  }, []);
  function renderCloseIcon() {
    if (!onDismiss) return null;
    return /*#__PURE__*/React.createElement(IconButton, _extends({
      "aria-label": locale.toast.ariaLabels.close(),
      onClick: onDismiss,
      ref: closeIconRef
    }, tagComponent("close", {
      "data-element": "close",
      ...closeButtonDataProps
    })), /*#__PURE__*/React.createElement(Icon, {
      type: "close"
    }));
  }
  const iconToRender = {
    notification: "alert",
    neutral: "info",
    success: "tick_circle",
    error: "error",
    info: "info",
    warning: "warning"
  };
  const toastIcon = iconToRender[variant] || "none";
  function renderToastContent() {
    if (!open) return null;
    let toastVariant = "success";
    if (!isNotice && !isNotification) {
      toastVariant = variant;
    }
    return /*#__PURE__*/React.createElement(CSSTransition, {
      enter: true,
      classNames: isNotice ? "toast-alternative" : "toast",
      timeout: {
        appear: 1600,
        enter: 1500,
        exit: 500
      },
      nodeRef: toastContentNodeRef
    }, /*#__PURE__*/React.createElement(StyledToast, _extends({
      align: align,
      alignY: alignY,
      isNotice: isNotice,
      isNotification: isNotification,
      className: className
    }, tagComponent(restProps["data-component"] || "toast", restProps), {
      isCenter: isCenter,
      variant: toastVariant,
      id: id,
      maxWidth: maxWidth,
      ref: toastContentNodeRef
    }, !disableAutoFocus && {
      tabIndex,
      onBlur: () => setTabIndex(undefined)
    }), !isNotice && /*#__PURE__*/React.createElement(TypeIcon, {
      variant: isNotification ? "info" : variant
    }, /*#__PURE__*/React.createElement(Icon, {
      type: toastIcon
    })), /*#__PURE__*/React.createElement(StyledToastContent, {
      isNotice: isNotice,
      isDismiss: !!onDismiss
    }, children), renderCloseIcon()));
  }
  return /*#__PURE__*/React.createElement(StyledPortal, {
    id: targetPortalId,
    align: align,
    alignY: alignY,
    isCenter: isCenter,
    isNotice: isNotice
  }, /*#__PURE__*/React.createElement(ToastWrapper, {
    align: align,
    isCenter: isCenter,
    ref: refToPass,
    isNotice: isNotice
  }, /*#__PURE__*/React.createElement(TransitionGroup, null, renderToastContent())));
});
if (process.env.NODE_ENV !== "production") {
  Toast.propTypes = {
    "align": PropTypes.oneOf(["center", "left", "right"]),
    "alignY": PropTypes.oneOf(["bottom", "center", "top"]),
    "children": PropTypes.node,
    "className": PropTypes.string,
    "closeButtonDataProps": PropTypes.shape({
      "data-element": PropTypes.string,
      "data-role": PropTypes.string
    }),
    "data-component": PropTypes.string,
    "disableAutoFocus": PropTypes.bool,
    "id": PropTypes.string,
    "isCenter": PropTypes.bool,
    "maxWidth": PropTypes.string,
    "onDismiss": PropTypes.func,
    "open": PropTypes.bool,
    "targetPortalId": PropTypes.string,
    "timeout": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "variant": PropTypes.oneOf(["error", "info", "neutral", "notice", "notification", "success", "warning"])
  };
}
export { Toast };
Toast.displayName = "Toast";
export default Toast;