function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useImperativeHandle, useRef, useState } from "react";
import PropTypes from "prop-types";
import guid from "../../__internal__/utils/helpers/guid";
import useLocale from "../../hooks/__internal__/useLocale";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import useInputAccessibility from "../../hooks/__internal__/useInputAccessibility";
import Fieldset from "../../__internal__/fieldset";
import Box from "../box";
import { ErrorBorder } from "../textbox/textbox.style";
import ValidationMessage from "../../__internal__/validation-message";
import Number from "../number";
import Typography from "../typography";
import { StyledLabel as Label, StyledHintText as Hint } from "./time.style";
import { TimeToggle } from "./__internal__/time-toggle";
const Time = /*#__PURE__*/React.forwardRef(({
  label,
  size = "medium",
  inputHint,
  hoursInputProps = {},
  minutesInputProps = {},
  value,
  name,
  onChange,
  onBlur,
  required,
  isOptional,
  disabled,
  readOnly,
  toggleProps = {},
  ...rest
}, ref) => {
  const {
    id: hoursInputId,
    label: hoursLabel,
    "aria-label": hoursAriaLabel,
    error: hoursError,
    warning: hoursWarning
  } = hoursInputProps;
  const {
    id: minutesInputId,
    label: minutesLabel,
    "aria-label": minutesAriaLabel,
    error: minutesError,
    warning: minutesWarning
  } = minutesInputProps;
  const internalHrsId = useRef(hoursInputId || guid());
  const internalMinsId = useRef(minutesInputId || guid());
  const inputHintId = useRef(guid());
  const internalId = useRef(`${internalHrsId.current} ${internalMinsId.current}`);
  const {
    hours: hourValue,
    minutes: minuteValue,
    period: toggleValue
  } = value;
  const [inputValues, setInputValues] = useState([hourValue, minuteValue]);
  const locale = useLocale();
  const showToggle = toggleValue !== undefined;
  const [period, setPeriod] = useState(toggleValue);
  const hrsLabel = hoursLabel || locale.time.hoursLabelText();
  const minsLabel = minutesLabel || locale.time.minutesLabelText();
  const hrsAriaLabel = hoursAriaLabel || locale.time.hoursAriaLabelText();
  const minsAriaLabel = minutesAriaLabel || locale.time.minutesAriaLabelText();
  const hoursRef = useRef(null);
  const minsRef = useRef(null);
  const computedValidations = (hrs, mins) => {
    const hoursIsString = typeof hrs === "string";
    const minutesIsString = typeof mins === "string";
    if (!hoursIsString && !minutesIsString) {
      return hrs || mins;
    }
    if (hoursIsString && !minutesIsString) {
      return hrs;
    }
    if (minutesIsString && !hoursIsString) {
      return mins;
    }
    return `${hrs} ${mins}`;
  };
  const error = computedValidations(hoursError, minutesError);
  const warning = computedValidations(hoursWarning, minutesWarning);
  const hasValidationFailure = !!(error || warning);
  const {
    validationId,
    ariaDescribedBy
  } = useInputAccessibility({
    id: internalId.current,
    validationRedesignOptIn: true,
    error,
    warning
  });
  const combinedAriaDescribedBy = [ariaDescribedBy, inputHintId.current].filter(Boolean).join(" ");
  useImperativeHandle(ref, () => ({
    focusHoursInput() {
      hoursRef.current?.focus();
    },
    focusMinutesInput() {
      minsRef.current?.focus();
    }
  }), []);
  const handleChange = (ev, inputName) => {
    const hours = inputName === "hrs" ? ev.target.value : inputValues[0];
    const minutes = inputName === "mins" ? ev.target.value : inputValues[1];
    setInputValues([hours, minutes]);
    onChange({
      target: {
        name,
        id: internalId.current,
        value: {
          hours,
          minutes,
          period
        }
      }
    });
  };
  const handlePeriodChange = periodName => {
    const [hours, minutes] = inputValues;
    setPeriod(periodName);
    onChange({
      target: {
        name,
        id: internalId.current,
        value: {
          hours,
          minutes,
          period: periodName
        }
      }
    });
  };
  const handleBlur = useCallback(ev => {
    setTimeout(() => {
      if (hoursRef.current !== document.activeElement && minsRef.current !== document.activeElement) {
        onBlur?.(ev);
      }
    });
  }, [onBlur]);
  return /*#__PURE__*/React.createElement(Fieldset, _extends({
    legend: label,
    legendMargin: {
      mb: 0
    },
    width: "fit-content",
    isRequired: required,
    isOptional: isOptional,
    isDisabled: disabled,
    name: name,
    id: internalId.current
  }, rest, tagComponent("time", rest), {
    "aria-describedby": combinedAriaDescribedBy
  }), inputHint && /*#__PURE__*/React.createElement(Hint, {
    id: inputHintId.current,
    isDisabled: disabled
  }, inputHint), /*#__PURE__*/React.createElement(Box, {
    position: "relative"
  }, /*#__PURE__*/React.createElement(ValidationMessage, {
    validationId: validationId,
    error: error,
    warning: warning
  }), hasValidationFailure && /*#__PURE__*/React.createElement(ErrorBorder, {
    warning: !!(!error && warning)
  }), /*#__PURE__*/React.createElement(Box, {
    display: "flex"
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Label, {
    "aria-label": hrsAriaLabel,
    htmlFor: internalHrsId.current,
    disabled: disabled
  }, hrsLabel), /*#__PURE__*/React.createElement(Number, _extends({}, hoursInputProps, {
    label: undefined,
    "data-component": "hours",
    ref: hoursRef,
    value: hourValue,
    onChange: ev => handleChange(ev, "hrs"),
    onBlur: handleBlur,
    id: internalHrsId.current,
    size: size,
    error: !!hoursError,
    warning: !!hoursWarning,
    disabled: disabled,
    readOnly: readOnly
  }))), /*#__PURE__*/React.createElement(Box, {
    display: "flex",
    flexDirection: "column",
    justifyContent: "center",
    mx: 1,
    "aria-hidden": "true"
  }, /*#__PURE__*/React.createElement("span", null, "\xA0"), /*#__PURE__*/React.createElement(Typography, {
    isDisabled: disabled,
    variant: "span",
    mb: "-4px"
  }, ":")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Label, {
    "aria-label": minsAriaLabel,
    htmlFor: internalMinsId.current,
    disabled: disabled
  }, minsLabel), /*#__PURE__*/React.createElement(Number, _extends({}, minutesInputProps, {
    label: undefined,
    "data-component": "minutes",
    ref: minsRef,
    value: minuteValue,
    onChange: ev => handleChange(ev, "mins"),
    onBlur: handleBlur,
    id: internalMinsId.current,
    size: size,
    error: !!minutesError,
    warning: !!minutesWarning,
    disabled: disabled,
    readOnly: readOnly
  }))), showToggle && /*#__PURE__*/React.createElement(Box, {
    display: "flex",
    flexDirection: "column",
    justifyContent: "flex-end"
  }, /*#__PURE__*/React.createElement(TimeToggle, {
    toggleProps: toggleProps,
    size: size,
    onChange: handlePeriodChange,
    toggleValue: toggleValue,
    disabled: disabled || readOnly
  })))));
});
if (process.env.NODE_ENV !== "production") {
  Time.propTypes = {
    "children": PropTypes.node,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "disabled": PropTypes.bool,
    "hoursInputProps": PropTypes.shape({
      "aria-label": PropTypes.string,
      "data-element": PropTypes.string,
      "data-role": PropTypes.string,
      "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
      "id": PropTypes.string,
      "label": PropTypes.string,
      "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool])
    }),
    "inputHint": PropTypes.string,
    "isOptional": PropTypes.bool,
    "label": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "minutesInputProps": PropTypes.shape({
      "aria-label": PropTypes.string,
      "data-element": PropTypes.string,
      "data-role": PropTypes.string,
      "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
      "id": PropTypes.string,
      "label": PropTypes.string,
      "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool])
    }),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "onBlur": PropTypes.func,
    "onChange": PropTypes.func.isRequired,
    "readOnly": PropTypes.bool,
    "required": PropTypes.bool,
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "toggleProps": PropTypes.shape({
      "amToggleProps": PropTypes.shape({
        "data-element": PropTypes.string,
        "data-role": PropTypes.string
      }),
      "pmToggleProps": PropTypes.shape({
        "data-element": PropTypes.string,
        "data-role": PropTypes.string
      }),
      "wrapperProps": PropTypes.shape({
        "data-element": PropTypes.string,
        "data-role": PropTypes.string
      })
    }),
    "value": PropTypes.shape({
      "hours": PropTypes.string.isRequired,
      "minutes": PropTypes.string.isRequired,
      "period": PropTypes.oneOf(["AM", "PM"])
    }).isRequired
  };
}
Time.displayName = "Time";
export default Time;