function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useCallback } from "react";
import PropTypes from "prop-types";
import guid from "../../../../__internal__/utils/helpers/guid";
import useLocale from "../../../../hooks/__internal__/useLocale";
import { ButtonToggle, ButtonToggleGroup } from "../../../button-toggle";
const Toggle = ({
  size,
  onChange,
  toggleValue,
  disabled,
  toggleProps
}) => {
  const locale = useLocale();
  const amText = locale.time.amText();
  const pmText = locale.time.pmText();
  const internalId = useRef(guid());
  const {
    wrapperProps,
    amToggleProps,
    pmToggleProps
  } = toggleProps || /* istanbul ignore next */{};
  const handleChange = useCallback(event => {
    const selectedButtonValue = event.target.value;
    if (selectedButtonValue !== toggleValue) {
      onChange(selectedButtonValue);
    }
  }, [toggleValue, onChange]);
  return /*#__PURE__*/React.createElement(ButtonToggleGroup, _extends({}, wrapperProps, {
    "data-component": "time-button-toggle-group",
    m: "0px 0px 0px 16px",
    id: internalId.current,
    onChange: handleChange,
    value: toggleValue,
    disabled: disabled
  }), /*#__PURE__*/React.createElement(ButtonToggle, _extends({}, amToggleProps, {
    "data-component": "am-button-toggle",
    value: "AM",
    size: size
  }), amText), /*#__PURE__*/React.createElement(ButtonToggle, _extends({}, pmToggleProps, {
    "data-component": "pm-button-toggle",
    value: "PM",
    size: size
  }), pmText));
};
Toggle.displayName = "Toggle";
export default Toggle;