function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import StyledTile from "./tile.style";
import TileContext from "./__internal__/tile-context";
import filterStyledSystemPaddingProps from "../../style/utils/filter-styled-system-padding-props";
import filterStyledSystemMarginProps from "../../style/utils/filter-styled-system-margin-props";
import computeContentPadding from "./__internal__/compute-content-padding";
import tagComponent from "../../__internal__/utils/helpers/tags";
export const Tile = ({
  variant = "tile",
  p = 3,
  children,
  orientation = "horizontal",
  width = "100%",
  roundness = "default",
  height,
  borderWidth,
  borderVariant,
  ...rest
}) => {
  const isHorizontal = orientation === "horizontal";
  const paddingProps = filterStyledSystemPaddingProps({
    p,
    ...rest
  });
  const marginProps = filterStyledSystemMarginProps(rest);
  const contentPaddingProps = computeContentPadding(paddingProps, isHorizontal);
  return /*#__PURE__*/React.createElement(StyledTile, _extends({
    variant: variant,
    width: width,
    height: height,
    isHorizontal: isHorizontal,
    p: p,
    roundness: roundness,
    borderWidth: borderWidth,
    borderVariant: borderVariant
  }, paddingProps, marginProps, tagComponent("tile", rest)), /*#__PURE__*/React.createElement(TileContext.Provider, {
    value: {
      isHorizontal,
      paddingPropsFromTile: contentPaddingProps
    }
  }, children));
};
export default Tile;