import styled, { css } from "styled-components";
import { padding } from "styled-system";
import { baseTheme } from "../../../style/themes";
const getBackgroundColor = variant => {
  switch (variant) {
    case "transparent":
      return "transparent";
    case "black":
      return "var(--colorsUtilityYin100)";
    case "grey":
      return "var(--colorsUtilityMajor025)";
    default:
      return "var(--colorsUtilityMajor100)";
  }
};
const StyledTileHeader = styled.div`
  ${padding}
  border-top-left-radius: calc(var(--tileBorderRadius) - 1px);
  border-top-right-radius: calc(var(--tileBorderRadius) - 1px);

  ${({
  variant
}) => css`
    background: ${getBackgroundColor(variant)};
    border-bottom: 1px solid
      ${variant === "grey" ? "var(--colorsUtilityMajor200)" : "var(--colorsUtilityMajor100)"};
  `}
`;
StyledTileHeader.defaultProps = {
  theme: baseTheme
};
export default StyledTileHeader;