function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import StyledTileContent from "./tile-content.style";
import TileContext from "../__internal__/tile-context";
import tagComponent from "../../../__internal__/utils/helpers/tags";
import filterStyledSystemPaddingProps from "../../../style/utils/filter-styled-system-padding-props";
import filterStyledSystemMarginProps from "../../../style/utils/filter-styled-system-margin-props";
const TileContent = ({
  children,
  width,
  height,
  ...rest
}) => {
  const {
    isHorizontal,
    paddingPropsFromTile
  } = useContext(TileContext);
  if (!children) {
    return null;
  }
  const spacingProps = {
    ...filterStyledSystemPaddingProps(rest),
    ...filterStyledSystemMarginProps(rest)
  };
  return /*#__PURE__*/React.createElement(StyledTileContent, _extends({
    width: width,
    height: height,
    isHorizontal: isHorizontal,
    isVertical: !isHorizontal
  }, paddingPropsFromTile, spacingProps, tagComponent("tile-content", rest)), children);
};
export default TileContent;