import React from "react";
import PropTypes from "prop-types";
import Box from "../../box";
const FlexTileContainer = ({
  children,
  columnGap = 2
}) => {
  if (!children) {
    return /*#__PURE__*/React.createElement(React.Fragment, null);
  }
  return /*#__PURE__*/React.createElement(Box, {
    alignContent: "stretch",
    alignItems: "stretch",
    display: "flex",
    flexDirection: "row",
    flexWrap: "wrap",
    columnGap: columnGap,
    justifyContent: "flex-start",
    overflow: "hidden",
    width: "100%",
    "data-component": "flex-tile-container"
  }, children);
};
if (process.env.NODE_ENV !== "production") {
  FlexTileContainer.propTypes = {
    "children": PropTypes.node,
    "columnGap": PropTypes.oneOfType([PropTypes.number, PropTypes.string])
  };
}
export { FlexTileContainer };
export default FlexTileContainer;