function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import Box from "../../box";
import tagComponent from "../../../__internal__/utils/helpers/tags";
const FlexTileCell = ({
  children,
  flexGrow = 1,
  flexBasis = "160px",
  flexShrink = 0,
  ...rest
}) => {
  if (!children) {
    return /*#__PURE__*/React.createElement(React.Fragment, null);
  }
  return /*#__PURE__*/React.createElement(Box, _extends({
    display: "flex",
    position: "relative",
    flexGrow: flexGrow,
    flexBasis: flexBasis,
    flexShrink: flexShrink
  }, rest, tagComponent("flex-tile-cell", rest)), children);
};
if (process.env.NODE_ENV !== "production") {
  FlexTileCell.propTypes = {
    "alignContent": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "space-around", "space-between", "space-evenly", "start", "stretch", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "space-around", "space-between", "space-evenly", "start", "stretch", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "alignItems": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "alignSelf": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "normal", "revert-layer", "revert", "self-end", "self-start", "start", "stretch", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "aria-hidden": PropTypes.oneOf(["false", "true"]),
    "as": PropTypes.oneOfType([PropTypes.oneOf(["a", "abbr", "address", "animate", "animateMotion", "animateTransform", "area", "article", "aside", "audio", "b", "base", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "circle", "cite", "clipPath", "code", "col", "colgroup", "data", "datalist", "dd", "defs", "del", "desc", "details", "dfn", "dialog", "div", "dl", "dt", "ellipse", "em", "embed", "feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence", "fieldset", "figcaption", "figure", "filter", "footer", "foreignObject", "form", "g", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "image", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "line", "linearGradient", "link", "main", "map", "mark", "marker", "mask", "menu", "menuitem", "meta", "metadata", "meter", "mpath", "nav", "noindex", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "path", "pattern", "picture", "polygon", "polyline", "pre", "progress", "q", "radialGradient", "rect", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "slot", "small", "source", "span", "stop", "strong", "style", "sub", "summary", "sup", "svg", "switch", "symbol", "table", "tbody", "td", "template", "text", "textarea", "textPath", "tfoot", "th", "thead", "time", "title", "tr", "track", "tspan", "u", "ul", "use", "var", "video", "view", "wbr", "webview"]), PropTypes.func, PropTypes.shape({
      "childContextTypes": PropTypes.object,
      "contextType": PropTypes.shape({
        "Consumer": PropTypes.func.isRequired,
        "displayName": PropTypes.string,
        "Provider": PropTypes.func.isRequired
      }),
      "contextTypes": PropTypes.object,
      "defaultProps": PropTypes.object,
      "displayName": PropTypes.string,
      "getDerivedStateFromError": PropTypes.func,
      "getDerivedStateFromProps": PropTypes.func,
      "propTypes": PropTypes.object
    })]),
    "backgroundColor": PropTypes.string,
    "bg": PropTypes.string,
    "borderRadius": PropTypes.any,
    "bottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "boxShadow": PropTypes.any,
    "boxSizing": PropTypes.oneOf(["border-box", "content-box"]),
    "children": PropTypes.node,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "columnGap": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "display": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "-ms-flexbox", "-ms-grid", "-ms-inline-flexbox", "-ms-inline-grid", "-webkit-flex", "-webkit-inline-flex", "block", "contents", "flex", "flow-root", "flow", "grid", "inherit", "initial", "inline-block", "inline-flex", "inline-grid", "inline-list-item", "inline-table", "inline", "list-item", "none", "revert-layer", "revert", "ruby-base-container", "ruby-base", "ruby-text-container", "ruby-text", "ruby", "run-in", "table-caption", "table-cell", "table-column-group", "table-column", "table-footer-group", "table-header-group", "table-row-group", "table-row", "table", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "-ms-flexbox", "-ms-grid", "-ms-inline-flexbox", "-ms-inline-grid", "-webkit-flex", "-webkit-inline-flex", "block", "contents", "flex", "flow-root", "flow", "grid", "inherit", "initial", "inline-block", "inline-flex", "inline-grid", "inline-list-item", "inline-table", "inline", "list-item", "none", "revert-layer", "revert", "ruby-base-container", "ruby-base", "ruby-text-container", "ruby-text", "ruby", "run-in", "table-caption", "table-cell", "table-column-group", "table-column", "table-footer-group", "table-header-group", "table-row-group", "table-row", "table", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "flex": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "flexBasis": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "flexDirection": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "column-reverse", "column", "inherit", "initial", "revert-layer", "revert", "row-reverse", "row", "unset"]), PropTypes.arrayOf(PropTypes.oneOf(["-moz-initial", "column-reverse", "column", "inherit", "initial", "revert-layer", "revert", "row-reverse", "row", "unset", null])), PropTypes.object]),
    "flexGrow": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "flexShrink": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "flexWrap": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "nowrap", "revert-layer", "revert", "unset", "wrap-reverse", "wrap"]), PropTypes.arrayOf(PropTypes.oneOf(["-moz-initial", "inherit", "initial", "nowrap", "revert-layer", "revert", "unset", "wrap-reverse", "wrap", null])), PropTypes.object]),
    "gap": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "gridArea": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "gridAutoColumns": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "gridAutoFlow": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "column", "dense", "inherit", "initial", "revert-layer", "revert", "row", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "column", "dense", "inherit", "initial", "revert-layer", "revert", "row", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "gridAutoRows": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "gridColumn": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "gridRow": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "inherit", "initial", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "gridTemplateAreas": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "none", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "none", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "gridTemplateColumns": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "gridTemplateRows": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "height": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "id": PropTypes.string,
    "justifyContent": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "space-around", "space-between", "space-evenly", "start", "stretch", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "space-around", "space-between", "space-evenly", "start", "stretch", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "justifyItems": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "legacy", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "legacy", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "justifySelf": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "auto", "baseline", "center", "end", "flex-end", "flex-start", "inherit", "initial", "left", "normal", "revert-layer", "revert", "right", "self-end", "self-start", "start", "stretch", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "left": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "maxHeight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "maxWidth": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "minHeight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "minWidth": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "opacity": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "order": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "inherit", "initial", "revert-layer", "revert", "unset", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "overflow": PropTypes.oneOfType([PropTypes.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible"]), PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible", null]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })])), PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "overflowWrap": PropTypes.oneOf(["anywhere", "break-word"]),
    "overflowX": PropTypes.oneOfType([PropTypes.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible"]), PropTypes.arrayOf(PropTypes.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible", null])), PropTypes.object]),
    "overflowY": PropTypes.oneOfType([PropTypes.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible"]), PropTypes.arrayOf(PropTypes.oneOf(["-moz-hidden-unscrollable", "-moz-initial", "auto", "clip", "hidden", "inherit", "initial", "revert-layer", "revert", "scroll", "unset", "visible", null])), PropTypes.object]),
    "p": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "padding": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pl": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "position": PropTypes.oneOfType([PropTypes.oneOf(["-moz-initial", "-webkit-sticky", "absolute", "fixed", "inherit", "initial", "relative", "revert-layer", "revert", "static", "sticky", "unset"]), PropTypes.arrayOf(PropTypes.oneOf(["-moz-initial", "-webkit-sticky", "absolute", "fixed", "inherit", "initial", "relative", "revert-layer", "revert", "static", "sticky", "unset", null])), PropTypes.object]),
    "pr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "px": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "py": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "right": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "role": PropTypes.string,
    "rowGap": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "scrollVariant": PropTypes.oneOf(["dark", "light"]),
    "size": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "tabIndex": PropTypes.number,
    "top": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "verticalAlign": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "width": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])
  };
}
export { FlexTileCell };
export default FlexTileCell;